/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.teterminationpointaugment.te;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfschedule.rev20160301.yrtietfschedule.schedules.Schedules;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected Schedules schedules;

    @Override
    public Schedules schedules() {
        return schedules;
    }

    @Override
    public void schedules(Schedules schedules) {
        this.schedules = schedules;
    }

    @Override
    public int hashCode() {
        return Objects.hash(schedules);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.equals(schedules, other.schedules);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("schedules=" + schedules)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }

}