/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.teterminationpointaugment.te;

import org.onosproject.yang.gen.v1.yrtietfschedule.rev20160301.yrtietfschedule.schedules.Schedules;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of config.
 */
public interface Config extends Augmentable  {

    /**
     * Returns the attribute schedules.
     *
     * @return schedules value of schedules
     */
    Schedules schedules();

    /**
     * Sets the attribute schedules.
     *
     * @param schedules value of schedules
     */
    void schedules(Schedules schedules);

}