/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfte.rev20170310.yrtietfte.tunnelsgrouping;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfte.rev20170310.yrtietfte.tunnelsgrouping.tunnels.Tunnel;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of tunnels.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTunnels extends InnerModelObject implements Tunnels {
    protected List<Tunnel> tunnel;

    @Override
    public List<Tunnel> tunnel() {
        return tunnel;
    }

    @Override
    public void tunnel(List<Tunnel> tunnel) {
        this.tunnel = tunnel;
    }

    @Override
    public void addToTunnel(Tunnel addTo) {
        if (tunnel == null) {
            tunnel = new ArrayList<>();
        }
        tunnel.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(tunnel);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnels) {
            DefaultTunnels other = (DefaultTunnels) obj;
            return
                Objects.equals(tunnel, other.tunnel);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tunnel=" + tunnel)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnels.
     */
    public DefaultTunnels() {
    }

}