/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.tpdfun3;

import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.Tpdfbit;
import org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.Tpdfempty;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of tpdfun3Union.
 */
public final class Tpdfun3Union {
    private Tpdfbit tpdfbit;
    private Tpdfempty tpdfempty;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of tpdfun3Union.
     */
    private Tpdfun3Union() {
    }

    /**
     * Creates an instance of tpdfbit.
     *
     * @param tpdfbit value of tpdfbit
     */
    public Tpdfun3Union(Tpdfbit tpdfbit) {
        setValue.set(0);
        this.tpdfbit = tpdfbit;
    }

    /**
     * Creates an instance of tpdfempty.
     *
     * @param tpdfempty value of tpdfempty
     */
    public Tpdfun3Union(Tpdfempty tpdfempty) {
        setValue.set(1);
        this.tpdfempty = tpdfempty;
    }

    /**
     * Returns the object of tpdfun3Union for type tpdfbit.
     *
     * @param value value of tpdfun3Union for type tpdfbit
     * @return tpdfun3Union for type tpdfbit
     */
    public static Tpdfun3Union of(Tpdfbit value) {
        return new Tpdfun3Union(value);
    }

    /**
     * Returns the object of tpdfun3Union for type tpdfempty.
     *
     * @param value value of tpdfun3Union for type tpdfempty
     * @return tpdfun3Union for type tpdfempty
     */
    public static Tpdfun3Union of(Tpdfempty value) {
        return new Tpdfun3Union(value);
    }

    /**
     * Returns the attribute tpdfbit.
     *
     * @return tpdfbit value of tpdfbit
     */
    public Tpdfbit tpdfbit() {
        return tpdfbit;
    }
    /**
     * Returns the attribute tpdfempty.
     *
     * @return tpdfempty value of tpdfempty
     */
    public Tpdfempty tpdfempty() {
        return tpdfempty;
    }
    /**
     * Sets the attribute tpdfbit.
     *
     * @param tpdfbit value of tpdfbit
     */
    public void tpdfbit(Tpdfbit tpdfbit) {
        this.tpdfbit = tpdfbit;
    }
    /**
     * Sets the attribute tpdfempty.
     *
     * @param tpdfempty value of tpdfempty
     */
    public void tpdfempty(Tpdfempty tpdfempty) {
        this.tpdfempty = tpdfempty;
    }

    @Override
    public int hashCode() {
        return Objects.hash(tpdfbit, tpdfempty);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tpdfun3Union) {
            Tpdfun3Union other = (Tpdfun3Union) obj;
            return
                Objects.equals(tpdfbit, other.tpdfbit) &&
                Objects.equals(tpdfempty, other.tpdfempty);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return tpdfbit.toString();
        }
        if (setValue.get(1)) {
            return tpdfempty.toString();
        }
        return null;
    }
    /**
     * Returns the object of tpdfun3Union fromString input String tpdfun3Union.
     *
     * @param valInString value of input String
     * @return tpdfun3Union
     */
    public static Tpdfun3Union fromString(String valInString) {
        try {
            Tpdfbit tmpVal = Tpdfbit.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Tpdfempty tmpVal = Tpdfempty.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
