/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion4Union.
 */
public final class Lfunion4Union {
    private boolean yangAutoPrefixBoolean;
    private String string;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion4Union.
     */
    private Lfunion4Union() {
    }

    /**
     * Creates an instance of yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public Lfunion4Union(boolean yangAutoPrefixBoolean) {
        setValue.set(0);
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public Lfunion4Union(String string) {
        setValue.set(1);
        this.string = string;
    }

    /**
     * Returns the object of lfunion4Union for type yangAutoPrefixBoolean.
     *
     * @param value value of lfunion4Union for type yangAutoPrefixBoolean
     * @return lfunion4Union for type yangAutoPrefixBoolean
     */
    public static Lfunion4Union of(boolean value) {
        return new Lfunion4Union(value);
    }

    /**
     * Returns the object of lfunion4Union for type string.
     *
     * @param value value of lfunion4Union for type string
     * @return lfunion4Union for type string
     */
    public static Lfunion4Union of(String value) {
        return new Lfunion4Union(value);
    }

    /**
     * Returns the attribute yangAutoPrefixBoolean.
     *
     * @return yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public boolean yangAutoPrefixBoolean() {
        return yangAutoPrefixBoolean;
    }
    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public void yangAutoPrefixBoolean(boolean yangAutoPrefixBoolean) {
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixBoolean, string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion4Union) {
            Lfunion4Union other = (Lfunion4Union) obj;
            return
                Objects.equals(yangAutoPrefixBoolean, other.yangAutoPrefixBoolean) &&
                Objects.equals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return yangAutoPrefixBoolean ? "true" : "false";
        }
        if (setValue.get(1)) {
            return string;
        }
        return null;
    }
    /**
     * Returns the object of lfunion4Union fromString input String lfunion4Union.
     *
     * @param valInString value of input String
     * @return lfunion4Union
     */
    public static Lfunion4Union fromString(String valInString) {
        try {
            boolean tmpVal = Boolean.parseBoolean(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
