/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll;
/**
 * Represents the implementation of iden.
 */
public abstract class Iden {

    /**
     * Returns the attribute iden.
     *
     * @return iden value of iden
     */
    public static String idenToString() {
        return "iden";
    }

    /**
     * Returns the object of iden fromString input String iden.
     *
     * @param valInString value of input String
     * @return iden
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("iden")) {
            return Iden.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}