/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont.lfunion14union;

/**
 * Represents ENUM data of lfunion14UnionEnum1.
 */
public enum Lfunion14UnionEnum1 {

    /**
     * Represents zero.
     */
    ZERO(0, "zero"),

    /**
     * Represents one.
     */
    ONE(1, "one");

    private int lfunion14UnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of lfunion14UnionEnum1.
     *
     * @param lfunion14UnionEnum1 value of lfunion14UnionEnum1
     */
     Lfunion14UnionEnum1(int lfunion14UnionEnum1, String schemaName) {
        this.lfunion14UnionEnum1 = lfunion14UnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lfunion14UnionEnum1 for.
     *
     * @param value value of lfunion14UnionEnum1 for
     * @return lfunion14UnionEnum1 for
     */
    public static Lfunion14UnionEnum1 of(int value) {
        switch (value) {
            case 0:
                return Lfunion14UnionEnum1.ZERO;
            case 1:
                return Lfunion14UnionEnum1.ONE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lfunion14UnionEnum1 for.
     *
     * @param value value of lfunion14UnionEnum1 for
     * @return lfunion14UnionEnum1 for
     */
    public static Lfunion14UnionEnum1 of(String value) {
        switch (value) {
            case "zero":
                return Lfunion14UnionEnum1.ZERO;
            case "one":
                return Lfunion14UnionEnum1.ONE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lfunion14UnionEnum1.
     *
     * @return lfunion14UnionEnum1 value of lfunion14UnionEnum1
     */
    public int lfunion14UnionEnum1() {
        return lfunion14UnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
