/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.tpdfbit.Bits;
import java.util.Objects;

/**
 * Represents the implementation of tpdfbit.
 */
public final class Tpdfbit {

    private BitSet bits;

    /**
     * Creates an instance of tpdfbit.
     */
    private Tpdfbit() {
    }

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
    public Tpdfbit(BitSet bits) {
        this.bits = bits;
    }

    /**
     * Returns the object of tpdfbit for type bits.
     *
     * @param value value of tpdfbit for type bits
     * @return tpdfbit for type bits
     */
    public static Tpdfbit of(BitSet value) {
        return new Tpdfbit(value);
    }

    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public BitSet bits() {
        return bits;
    }
    /**
     * Sets the attribute bits.
     *
     * @param bits value of bits
     */
    public void bits(BitSet bits) {
        this.bits = bits;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bits);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tpdfbit) {
            Tpdfbit other = (Tpdfbit) obj;
            return
                Objects.equals(bits, other.bits);
        }
        return false;
    }

    @Override
    public String toString() {
        return Bits.toString(bits);
    }
    /**
     * Returns the object of tpdfbit fromString input String tpdfbit.
     *
     * @param valInString value of input String
     * @return tpdfbit
     */
    public static Tpdfbit fromString(String valInString) {
        try {
            BitSet tmpVal = Bits.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
