/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.sample.sample;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.sample.sample.top.YangAutoPrefixInterface;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of top.
 */
public interface Top extends Augmentable  {

    /**
     * Identify the leaf of Top.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents mtu.
         */
        MTU(1),
        /**
         * Represents color.
         */
        COLOR(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute mtu.
     *
     * @return mtu value of mtu
     */
    String mtu();

    /**
     * Returns the attribute color.
     *
     * @return color list of color
     */
    List<String> color();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute yangAutoPrefixInterface.
     *
     * @return yangAutoPrefixInterface list of yangAutoPrefixInterface
     */
    List<YangAutoPrefixInterface> yangAutoPrefixInterface();

    /**
     * Sets the attribute mtu.
     *
     * @param mtu value of mtu
     */
    void mtu(String mtu);

    /**
     * Sets the attribute color.
     *
     * @param color list of color
     */
    void color(List<String> color);

    /**
     * Sets the attribute yangAutoPrefixInterface.
     *
     * @param yangAutoPrefixInterface list of yangAutoPrefixInterface
     */
    void yangAutoPrefixInterface(List<YangAutoPrefixInterface> yangAutoPrefixInterface);

    /**
     * Adds to the list of color.
     *
     * @param addTo value of color
     */
    void addToColor(String addTo);

    /**
     * Adds to the list of yangAutoPrefixInterface.
     *
     * @param addTo value of yangAutoPrefixInterface
     */
    void addToYangAutoPrefixInterface(YangAutoPrefixInterface addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}