/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerChoice;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerGrouping;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerLeaf;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerLeafList;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ContainerList;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.ListInList;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.OnlyContainer;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of firstLevel.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultFirstLevel extends InnerModelObject implements FirstLevel {
    protected OnlyContainer onlyContainer;
    protected ContainerLeaf containerLeaf;
    protected ContainerLeafList containerLeafList;
    protected ContainerList containerList;
    protected ContainerChoice containerChoice;
    protected ContainerGrouping containerGrouping;
    protected List<ListInList> listInList;

    @Override
    public OnlyContainer onlyContainer() {
        return onlyContainer;
    }

    @Override
    public ContainerLeaf containerLeaf() {
        return containerLeaf;
    }

    @Override
    public ContainerLeafList containerLeafList() {
        return containerLeafList;
    }

    @Override
    public ContainerList containerList() {
        return containerList;
    }

    @Override
    public ContainerChoice containerChoice() {
        return containerChoice;
    }

    @Override
    public ContainerGrouping containerGrouping() {
        return containerGrouping;
    }

    @Override
    public List<ListInList> listInList() {
        return listInList;
    }

    @Override
    public void onlyContainer(OnlyContainer onlyContainer) {
        this.onlyContainer = onlyContainer;
    }

    @Override
    public void containerLeaf(ContainerLeaf containerLeaf) {
        this.containerLeaf = containerLeaf;
    }

    @Override
    public void containerLeafList(ContainerLeafList containerLeafList) {
        this.containerLeafList = containerLeafList;
    }

    @Override
    public void containerList(ContainerList containerList) {
        this.containerList = containerList;
    }

    @Override
    public void containerChoice(ContainerChoice containerChoice) {
        this.containerChoice = containerChoice;
    }

    @Override
    public void containerGrouping(ContainerGrouping containerGrouping) {
        this.containerGrouping = containerGrouping;
    }

    @Override
    public void listInList(List<ListInList> listInList) {
        this.listInList = listInList;
    }

    @Override
    public void addToListInList(ListInList addTo) {
        if (listInList == null) {
            listInList = new ArrayList<>();
        }
        listInList.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(onlyContainer, containerLeaf, containerLeafList, containerList, containerChoice, containerGrouping, listInList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFirstLevel) {
            DefaultFirstLevel other = (DefaultFirstLevel) obj;
            return
                Objects.equals(onlyContainer, other.onlyContainer) &&
                Objects.equals(containerLeaf, other.containerLeaf) &&
                Objects.equals(containerLeafList, other.containerLeafList) &&
                Objects.equals(containerList, other.containerList) &&
                Objects.equals(containerChoice, other.containerChoice) &&
                Objects.equals(containerGrouping, other.containerGrouping) &&
                Objects.equals(listInList, other.listInList);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("onlyContainer=" + onlyContainer)
            .add("containerLeaf=" + containerLeaf)
            .add("containerLeafList=" + containerLeafList)
            .add("containerList=" + containerList)
            .add("containerChoice=" + containerChoice)
            .add("containerGrouping=" + containerGrouping)
            .add("listInList=" + listInList)
            .toString();
    }


    /**
     * Creates an instance of defaultFirstLevel.
     */
    public DefaultFirstLevel() {
    }

}