/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.FirstLevel;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of modelDataToResourceData.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class ModelDataToResourceDataOpParam extends InnerModelObject implements ModelDataToResourceData {
    protected int leaf1;
    protected List<String> leafList1;
    protected BitSet valueLeafFlags = new BitSet();
    protected FirstLevel firstLevel;

    @Override
    public int leaf1() {
        return leaf1;
    }

    @Override
    public List<String> leafList1() {
        return leafList1;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public FirstLevel firstLevel() {
        return firstLevel;
    }

    @Override
    public void leaf1(int leaf1) {
        valueLeafFlags.set(LeafIdentifier.LEAF1.getLeafIndex());
        this.leaf1 = leaf1;
    }

    @Override
    public void leafList1(List<String> leafList1) {
        valueLeafFlags.set(LeafIdentifier.LEAFLIST1.getLeafIndex());
        this.leafList1 = leafList1;
    }

    @Override
    public void firstLevel(FirstLevel firstLevel) {
        this.firstLevel = firstLevel;
    }

    @Override
    public void addToLeafList1(String addTo) {
        if (leafList1 == null) {
            leafList1 = new ArrayList<>();
        }
        leafList1.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf1, leafList1, valueLeafFlags, firstLevel);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModelDataToResourceDataOpParam) {
            ModelDataToResourceDataOpParam other = (ModelDataToResourceDataOpParam) obj;
            return
                Objects.equals(leaf1, other.leaf1) &&
                Objects.equals(leafList1, other.leafList1) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(firstLevel, other.firstLevel);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf1=" + leaf1)
            .add("leafList1=" + leafList1)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("firstLevel=" + firstLevel)
            .toString();
    }

    /**
     * Creates an instance of modelDataToResourceDataOpParam.
     */
    public ModelDataToResourceDataOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}