/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.FirstLevel;

/**
 * Abstraction of an entity which represents the functionality of modelDataToResourceData.
 */
public interface ModelDataToResourceData {

    /**
     * Identify the leaf of ModelDataToResourceData.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf1.
         */
        LEAF1(1),
        /**
         * Represents leafList1.
         */
        LEAFLIST1(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 value of leaf1
     */
    int leaf1();

    /**
     * Returns the attribute leafList1.
     *
     * @return leafList1 list of leafList1
     */
    List<String> leafList1();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute firstLevel.
     *
     * @return firstLevel value of firstLevel
     */
    FirstLevel firstLevel();

    /**
     * Sets the attribute leaf1.
     *
     * @param leaf1 value of leaf1
     */
    void leaf1(int leaf1);

    /**
     * Sets the attribute leafList1.
     *
     * @param leafList1 list of leafList1
     */
    void leafList1(List<String> leafList1);

    /**
     * Sets the attribute firstLevel.
     *
     * @param firstLevel value of firstLevel
     */
    void firstLevel(FirstLevel firstLevel);

    /**
     * Adds to the list of leafList1.
     *
     * @param addTo value of leafList1
     */
    void addToLeafList1(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}