/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.requestedtypegrouping.requestedtypeprofile.RequestedTypeChoice;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of requestedTypeProfile.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRequestedTypeProfile extends InnerModelObject implements RequestedTypeProfile {
    protected String circuitId;
    protected BitSet valueLeafFlags = new BitSet();
    protected RequestedTypeChoice requestedTypeChoice;

    @Override
    public String circuitId() {
        return circuitId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public RequestedTypeChoice requestedTypeChoice() {
        return requestedTypeChoice;
    }

    @Override
    public void circuitId(String circuitId) {
        valueLeafFlags.set(LeafIdentifier.CIRCUITID.getLeafIndex());
        this.circuitId = circuitId;
    }

    @Override
    public void requestedTypeChoice(RequestedTypeChoice requestedTypeChoice) {
        this.requestedTypeChoice = requestedTypeChoice;
    }

    @Override
    public int hashCode() {
        return Objects.hash(circuitId, valueLeafFlags, requestedTypeChoice);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRequestedTypeProfile) {
            DefaultRequestedTypeProfile other = (DefaultRequestedTypeProfile) obj;
            return
                Objects.equals(circuitId, other.circuitId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(requestedTypeChoice, other.requestedTypeChoice);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("circuitId=" + circuitId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("requestedTypeChoice=" + requestedTypeChoice)
            .toString();
    }


    /**
     * Creates an instance of defaultRequestedTypeProfile.
     */
    public DefaultRequestedTypeProfile() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}