/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.rdrtprofile.siterole.customcase;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.RouteDistinguisher;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.rdrtprofile.siterole.customcase.custom.ExportRt;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.rdrtprofile.siterole.customcase.custom.ImportRt;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of custom.
 */
public interface Custom extends Augmentable  {

    /**
     * Identify the leaf of Custom.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents rd.
         */
        RD(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute rd.
     *
     * @return rd value of rd
     */
    RouteDistinguisher rd();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute importRt.
     *
     * @return importRt list of importRt
     */
    List<ImportRt> importRt();

    /**
     * Returns the attribute exportRt.
     *
     * @return exportRt list of exportRt
     */
    List<ExportRt> exportRt();

    /**
     * Sets the attribute rd.
     *
     * @param rd value of rd
     */
    void rd(RouteDistinguisher rd);

    /**
     * Sets the attribute importRt.
     *
     * @param importRt list of importRt
     */
    void importRt(List<ImportRt> importRt);

    /**
     * Sets the attribute exportRt.
     *
     * @param exportRt list of exportRt
     */
    void exportRt(List<ExportRt> exportRt);

    /**
     * Adds to the list of importRt.
     *
     * @param addTo value of importRt
     */
    void addToImportRt(ImportRt addTo);

    /**
     * Adds to the list of exportRt.
     *
     * @param addTo value of exportRt
     */
    void addToExportRt(ExportRt addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}