/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.vpnservices.vpnsvc.transportconstraints.unicasttransportconstraints.constraint.constraintlist;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedL3VpnConstraintList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedL3VpnConstraintList extends InnerModelObject implements AugmentedL3VpnConstraintList {
    protected String constraintOpaqueValue2;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String constraintOpaqueValue2() {
        return constraintOpaqueValue2;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void constraintOpaqueValue2(String constraintOpaqueValue2) {
        valueLeafFlags.set(LeafIdentifier.CONSTRAINTOPAQUEVALUE2.getLeafIndex());
        this.constraintOpaqueValue2 = constraintOpaqueValue2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(constraintOpaqueValue2, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedL3VpnConstraintList) {
            DefaultAugmentedL3VpnConstraintList other = (DefaultAugmentedL3VpnConstraintList) obj;
            return
                Objects.equals(constraintOpaqueValue2, other.constraintOpaqueValue2) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("constraintOpaqueValue2=" + constraintOpaqueValue2)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedL3VpnConstraintList.
     */
    public DefaultAugmentedL3VpnConstraintList() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}