/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosprofile.QosProfile;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile.customunicom.InboundClasses;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile.customunicom.OutboundClasses;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of customUnicom.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCustomUnicom extends InnerModelObject implements CustomUnicom {
    protected InboundClasses inboundClasses;
    protected OutboundClasses outboundClasses;

    @Override
    public InboundClasses inboundClasses() {
        return inboundClasses;
    }

    @Override
    public OutboundClasses outboundClasses() {
        return outboundClasses;
    }

    @Override
    public void inboundClasses(InboundClasses inboundClasses) {
        this.inboundClasses = inboundClasses;
    }

    @Override
    public void outboundClasses(OutboundClasses outboundClasses) {
        this.outboundClasses = outboundClasses;
    }

    @Override
    public int hashCode() {
        return Objects.hash(inboundClasses, outboundClasses);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCustomUnicom) {
            DefaultCustomUnicom other = (DefaultCustomUnicom) obj;
            return
                Objects.equals(inboundClasses, other.inboundClasses) &&
                Objects.equals(outboundClasses, other.outboundClasses);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("inboundClasses=" + inboundClasses)
            .add("outboundClasses=" + outboundClasses)
            .toString();
    }


    /**
     * Creates an instance of defaultCustomUnicom.
     */
    public DefaultCustomUnicom() {
    }

}