/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.bgpprofile;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of soo.
 */
public interface Soo extends Augmentable  {

    /**
     * Identify the leaf of Soo.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents sooEnabled.
         */
        SOOENABLED(1),
        /**
         * Represents sooValue.
         */
        SOOVALUE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute sooEnabled.
     *
     * @return sooEnabled value of sooEnabled
     */
    boolean sooEnabled();

    /**
     * Returns the attribute sooValue.
     *
     * @return sooValue value of sooValue
     */
    String sooValue();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute sooEnabled.
     *
     * @param sooEnabled value of sooEnabled
     */
    void sooEnabled(boolean sooEnabled);

    /**
     * Sets the attribute sooValue.
     *
     * @param sooValue value of sooValue
     */
    void sooValue(String sooValue);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}