/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast;

import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.customertreeflavors.TreeFlavor;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of customerTreeFlavors.
 */
public interface CustomerTreeFlavors extends Augmentable  {

    /**
     * Returns the attribute treeFlavor.
     *
     * @return treeFlavor list of treeFlavor
     */
    List<TreeFlavor> treeFlavor();

    /**
     * Sets the attribute treeFlavor.
     *
     * @param treeFlavor list of treeFlavor
     */
    void treeFlavor(List<TreeFlavor> treeFlavor);

    /**
     * Adds to the list of treeFlavor.
     *
     * @param addTo value of treeFlavor
     */
    void addToTreeFlavor(TreeFlavor addTo);

}