/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess.AuthorizedSites;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess.DeniedSites;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of cloudAccess.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCloudAccess extends InnerModelObject 
        implements CloudAccess, MultiInstanceObject<CloudAccessKeys> {
    protected String cloudIdentifier;
    protected boolean natEnabled;
    protected Ipv4Address customerNatAddress;
    protected BitSet valueLeafFlags = new BitSet();
    protected AuthorizedSites authorizedSites;
    protected DeniedSites deniedSites;

    @Override
    public String cloudIdentifier() {
        return cloudIdentifier;
    }

    @Override
    public boolean natEnabled() {
        return natEnabled;
    }

    @Override
    public Ipv4Address customerNatAddress() {
        return customerNatAddress;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public AuthorizedSites authorizedSites() {
        return authorizedSites;
    }

    @Override
    public DeniedSites deniedSites() {
        return deniedSites;
    }

    @Override
    public void cloudIdentifier(String cloudIdentifier) {
        valueLeafFlags.set(LeafIdentifier.CLOUDIDENTIFIER.getLeafIndex());
        this.cloudIdentifier = cloudIdentifier;
    }

    @Override
    public void natEnabled(boolean natEnabled) {
        valueLeafFlags.set(LeafIdentifier.NATENABLED.getLeafIndex());
        this.natEnabled = natEnabled;
    }

    @Override
    public void customerNatAddress(Ipv4Address customerNatAddress) {
        valueLeafFlags.set(LeafIdentifier.CUSTOMERNATADDRESS.getLeafIndex());
        this.customerNatAddress = customerNatAddress;
    }

    @Override
    public void authorizedSites(AuthorizedSites authorizedSites) {
        this.authorizedSites = authorizedSites;
    }

    @Override
    public void deniedSites(DeniedSites deniedSites) {
        this.deniedSites = deniedSites;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cloudIdentifier, natEnabled, customerNatAddress, valueLeafFlags, authorizedSites, deniedSites);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCloudAccess) {
            DefaultCloudAccess other = (DefaultCloudAccess) obj;
            return
                Objects.equals(cloudIdentifier, other.cloudIdentifier) &&
                Objects.equals(natEnabled, other.natEnabled) &&
                Objects.equals(customerNatAddress, other.customerNatAddress) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(authorizedSites, other.authorizedSites) &&
                Objects.equals(deniedSites, other.deniedSites);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cloudIdentifier=" + cloudIdentifier)
            .add("natEnabled=" + natEnabled)
            .add("customerNatAddress=" + customerNatAddress)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("authorizedSites=" + authorizedSites)
            .add("deniedSites=" + deniedSites)
            .toString();
    }


    /**
     * Creates an instance of defaultCloudAccess.
     */
    public DefaultCloudAccess() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}