/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.Filter;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.Vpn;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of entries.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultEntries extends InnerModelObject 
        implements Entries, MultiInstanceObject<EntriesKeys> {
    protected SvcId id;
    protected BitSet valueLeafFlags = new BitSet();
    protected Filter filter;
    protected Vpn vpn;

    @Override
    public SvcId id() {
        return id;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Filter filter() {
        return filter;
    }

    @Override
    public Vpn vpn() {
        return vpn;
    }

    @Override
    public void id(SvcId id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void filter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void vpn(Vpn vpn) {
        this.vpn = vpn;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, valueLeafFlags, filter, vpn);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEntries) {
            DefaultEntries other = (DefaultEntries) obj;
            return
                Objects.equals(id, other.id) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(filter, other.filter) &&
                Objects.equals(vpn, other.vpn);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("filter=" + filter)
            .add("vpn=" + vpn)
            .toString();
    }


    /**
     * Creates an instance of defaultEntries.
     */
    public DefaultEntries() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}