/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy.rule.matchtype;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosclassificationpolicy.rule.MatchType;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of matchFlow.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMatchFlow extends InnerModelObject implements MatchFlow {
    protected org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.flowdefinition.MatchFlow matchFlow;

    @Override
    public org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.flowdefinition.MatchFlow matchFlow() {
        return matchFlow;
    }

    @Override
    public void matchFlow(org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.flowdefinition.MatchFlow matchFlow) {
        this.matchFlow = matchFlow;
    }

    @Override
    public int hashCode() {
        return Objects.hash(matchFlow);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMatchFlow) {
            DefaultMatchFlow other = (DefaultMatchFlow) obj;
            return
                Objects.equals(matchFlow, other.matchFlow);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("matchFlow=" + matchFlow)
            .toString();
    }


    /**
     * Creates an instance of defaultMatchFlow.
     */
    public DefaultMatchFlow() {
    }

}