/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.routingprotocols.routingprotocol.ospf.ShamLinks;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DottedQuad;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of ospf.
 */
public interface Ospf extends Augmentable  {

    /**
     * Identify the leaf of Ospf.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents areaAddress.
         */
        AREAADDRESS(1),
        /**
         * Represents metric.
         */
        METRIC(2),
        /**
         * Represents addressFamily.
         */
        ADDRESSFAMILY(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute areaAddress.
     *
     * @return areaAddress value of areaAddress
     */
    DottedQuad areaAddress();

    /**
     * Returns the attribute metric.
     *
     * @return metric value of metric
     */
    int metric();

    /**
     * Returns the attribute addressFamily.
     *
     * @return addressFamily list of addressFamily
     */
    List<Class<? extends AddressFamily>> addressFamily();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute shamLinks.
     *
     * @return shamLinks value of shamLinks
     */
    ShamLinks shamLinks();

    /**
     * Sets the attribute areaAddress.
     *
     * @param areaAddress value of areaAddress
     */
    void areaAddress(DottedQuad areaAddress);

    /**
     * Sets the attribute metric.
     *
     * @param metric value of metric
     */
    void metric(int metric);

    /**
     * Sets the attribute addressFamily.
     *
     * @param addressFamily list of addressFamily
     */
    void addressFamily(List<Class<? extends AddressFamily>> addressFamily);

    /**
     * Sets the attribute shamLinks.
     *
     * @param shamLinks value of shamLinks
     */
    void shamLinks(ShamLinks shamLinks);

    /**
     * Adds to the list of addressFamily.
     *
     * @param addTo value of addressFamily
     */
    void addToAddressFamily(Class<? extends AddressFamily> addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}