/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemaximumroutes.maximumroutes;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of addressFamily.
 */
public class AddressFamilyKeys implements KeyInfo<DefaultAddressFamily> {
    protected Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily> af;
    /**
     * Returns the attribute af.
     *
     * @return af value of af
     */
    public Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily> af() {
        return af;
    }

    /**
     * Sets the value to attribute af.
     *
     * @param af value of af
     */
    public void af(Class<? extends org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.AddressFamily> af) {
        this.af = af;
    }


    @Override
    public int hashCode() {
        return Objects.hash(af);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AddressFamilyKeys) {
            AddressFamilyKeys other = (AddressFamilyKeys) obj;
            return
                Objects.equals(af, other.af);
        }
        return false;
    }
}