/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.multicastrpgroupcfg.groupformat;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.multicastrpgroupcfg.GroupFormat;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of startend.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultStartend extends InnerModelObject implements Startend {
    protected IpAddress groupStart;
    protected IpAddress groupEnd;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public IpAddress groupStart() {
        return groupStart;
    }

    @Override
    public IpAddress groupEnd() {
        return groupEnd;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void groupStart(IpAddress groupStart) {
        valueLeafFlags.set(LeafIdentifier.GROUPSTART.getLeafIndex());
        this.groupStart = groupStart;
    }

    @Override
    public void groupEnd(IpAddress groupEnd) {
        valueLeafFlags.set(LeafIdentifier.GROUPEND.getLeafIndex());
        this.groupEnd = groupEnd;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupStart, groupEnd, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultStartend) {
            DefaultStartend other = (DefaultStartend) obj;
            return
                Objects.equals(groupStart, other.groupStart) &&
                Objects.equals(groupEnd, other.groupEnd) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("groupStart=" + groupStart)
            .add("groupEnd=" + groupEnd)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultStartend.
     */
    public DefaultStartend() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}