/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SiteVpnFlavor;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.customerlocationinfo.Location;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.site.SiteNetworkAccesses;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitediversity.SiteDiversity;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemanagement.Management;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemaximumroutes.MaximumRoutes;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteprotection.TrafficProtection;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.RoutingProtocols;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurity.Security;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservice.Service;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.VpnPolicyList;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of site.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSite extends InnerModelObject 
        implements Site, MultiInstanceObject<SiteKeys> {
    protected SvcId siteId;
    protected DateAndTime requestedSiteStart;
    protected DateAndTime requestedSiteStop;
    protected Class<? extends SiteVpnFlavor> siteVpnFlavor;
    protected DateAndTime actualSiteStart;
    protected DateAndTime actualSiteStop;
    protected BitSet valueLeafFlags = new BitSet();
    protected SiteNetworkAccesses siteNetworkAccesses;
    protected Location location;
    protected SiteDiversity siteDiversity;
    protected Management management;
    protected VpnPolicyList vpnPolicyList;
    protected MaximumRoutes maximumRoutes;
    protected Security security;
    protected Service service;
    protected TrafficProtection trafficProtection;
    protected RoutingProtocols routingProtocols;

    @Override
    public SvcId siteId() {
        return siteId;
    }

    @Override
    public DateAndTime requestedSiteStart() {
        return requestedSiteStart;
    }

    @Override
    public DateAndTime requestedSiteStop() {
        return requestedSiteStop;
    }

    @Override
    public Class<? extends SiteVpnFlavor> siteVpnFlavor() {
        return siteVpnFlavor;
    }

    @Override
    public DateAndTime actualSiteStart() {
        return actualSiteStart;
    }

    @Override
    public DateAndTime actualSiteStop() {
        return actualSiteStop;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public SiteNetworkAccesses siteNetworkAccesses() {
        return siteNetworkAccesses;
    }

    @Override
    public Location location() {
        return location;
    }

    @Override
    public SiteDiversity siteDiversity() {
        return siteDiversity;
    }

    @Override
    public Management management() {
        return management;
    }

    @Override
    public VpnPolicyList vpnPolicyList() {
        return vpnPolicyList;
    }

    @Override
    public MaximumRoutes maximumRoutes() {
        return maximumRoutes;
    }

    @Override
    public Security security() {
        return security;
    }

    @Override
    public Service service() {
        return service;
    }

    @Override
    public TrafficProtection trafficProtection() {
        return trafficProtection;
    }

    @Override
    public RoutingProtocols routingProtocols() {
        return routingProtocols;
    }

    @Override
    public void siteId(SvcId siteId) {
        valueLeafFlags.set(LeafIdentifier.SITEID.getLeafIndex());
        this.siteId = siteId;
    }

    @Override
    public void requestedSiteStart(DateAndTime requestedSiteStart) {
        valueLeafFlags.set(LeafIdentifier.REQUESTEDSITESTART.getLeafIndex());
        this.requestedSiteStart = requestedSiteStart;
    }

    @Override
    public void requestedSiteStop(DateAndTime requestedSiteStop) {
        valueLeafFlags.set(LeafIdentifier.REQUESTEDSITESTOP.getLeafIndex());
        this.requestedSiteStop = requestedSiteStop;
    }

    @Override
    public void siteVpnFlavor(Class<? extends SiteVpnFlavor> siteVpnFlavor) {
        valueLeafFlags.set(LeafIdentifier.SITEVPNFLAVOR.getLeafIndex());
        this.siteVpnFlavor = siteVpnFlavor;
    }

    @Override
    public void actualSiteStart(DateAndTime actualSiteStart) {
        valueLeafFlags.set(LeafIdentifier.ACTUALSITESTART.getLeafIndex());
        this.actualSiteStart = actualSiteStart;
    }

    @Override
    public void actualSiteStop(DateAndTime actualSiteStop) {
        valueLeafFlags.set(LeafIdentifier.ACTUALSITESTOP.getLeafIndex());
        this.actualSiteStop = actualSiteStop;
    }

    @Override
    public void siteNetworkAccesses(SiteNetworkAccesses siteNetworkAccesses) {
        this.siteNetworkAccesses = siteNetworkAccesses;
    }

    @Override
    public void location(Location location) {
        this.location = location;
    }

    @Override
    public void siteDiversity(SiteDiversity siteDiversity) {
        this.siteDiversity = siteDiversity;
    }

    @Override
    public void management(Management management) {
        this.management = management;
    }

    @Override
    public void vpnPolicyList(VpnPolicyList vpnPolicyList) {
        this.vpnPolicyList = vpnPolicyList;
    }

    @Override
    public void maximumRoutes(MaximumRoutes maximumRoutes) {
        this.maximumRoutes = maximumRoutes;
    }

    @Override
    public void security(Security security) {
        this.security = security;
    }

    @Override
    public void service(Service service) {
        this.service = service;
    }

    @Override
    public void trafficProtection(TrafficProtection trafficProtection) {
        this.trafficProtection = trafficProtection;
    }

    @Override
    public void routingProtocols(RoutingProtocols routingProtocols) {
        this.routingProtocols = routingProtocols;
    }

    @Override
    public int hashCode() {
        return Objects.hash(siteId, requestedSiteStart, requestedSiteStop, siteVpnFlavor, actualSiteStart, actualSiteStop, valueLeafFlags, siteNetworkAccesses, location, siteDiversity, management, vpnPolicyList, maximumRoutes, security, service, trafficProtection, routingProtocols);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSite) {
            DefaultSite other = (DefaultSite) obj;
            return
                Objects.equals(siteId, other.siteId) &&
                Objects.equals(requestedSiteStart, other.requestedSiteStart) &&
                Objects.equals(requestedSiteStop, other.requestedSiteStop) &&
                Objects.equals(siteVpnFlavor, other.siteVpnFlavor) &&
                Objects.equals(actualSiteStart, other.actualSiteStart) &&
                Objects.equals(actualSiteStop, other.actualSiteStop) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(siteNetworkAccesses, other.siteNetworkAccesses) &&
                Objects.equals(location, other.location) &&
                Objects.equals(siteDiversity, other.siteDiversity) &&
                Objects.equals(management, other.management) &&
                Objects.equals(vpnPolicyList, other.vpnPolicyList) &&
                Objects.equals(maximumRoutes, other.maximumRoutes) &&
                Objects.equals(security, other.security) &&
                Objects.equals(service, other.service) &&
                Objects.equals(trafficProtection, other.trafficProtection) &&
                Objects.equals(routingProtocols, other.routingProtocols);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("siteId=" + siteId)
            .add("requestedSiteStart=" + requestedSiteStart)
            .add("requestedSiteStop=" + requestedSiteStop)
            .add("siteVpnFlavor=" + siteVpnFlavor)
            .add("actualSiteStart=" + actualSiteStart)
            .add("actualSiteStop=" + actualSiteStop)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("siteNetworkAccesses=" + siteNetworkAccesses)
            .add("location=" + location)
            .add("siteDiversity=" + siteDiversity)
            .add("management=" + management)
            .add("vpnPolicyList=" + vpnPolicyList)
            .add("maximumRoutes=" + maximumRoutes)
            .add("security=" + security)
            .add("service=" + service)
            .add("trafficProtection=" + trafficProtection)
            .add("routingProtocols=" + routingProtocols)
            .toString();
    }


    /**
     * Creates an instance of defaultSite.
     */
    public DefaultSite() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}