/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.flowdefinition;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.flowdefinition.matchflow.ProtocolFieldUnion;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Prefix;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv6Prefix;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of matchFlow.
 */
public interface MatchFlow extends Augmentable  {

    /**
     * Identify the leaf of MatchFlow.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents dscp.
         */
        DSCP(1),
        /**
         * Represents tos.
         */
        TOS(2),
        /**
         * Represents dot1p.
         */
        DOT1P(3),
        /**
         * Represents ipv4SrcPrefix.
         */
        IPV4SRCPREFIX(4),
        /**
         * Represents ipv6SrcPrefix.
         */
        IPV6SRCPREFIX(5),
        /**
         * Represents ipv4DstPrefix.
         */
        IPV4DSTPREFIX(6),
        /**
         * Represents ipv6DstPrefix.
         */
        IPV6DSTPREFIX(7),
        /**
         * Represents l4SrcPort.
         */
        L4SRCPORT(8),
        /**
         * Represents l4DstPort.
         */
        L4DSTPORT(9),
        /**
         * Represents protocolField.
         */
        PROTOCOLFIELD(10);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute dscp.
     *
     * @return dscp value of dscp
     */
    short dscp();

    /**
     * Returns the attribute tos.
     *
     * @return tos value of tos
     */
    short tos();

    /**
     * Returns the attribute dot1p.
     *
     * @return dot1p value of dot1p
     */
    short dot1p();

    /**
     * Returns the attribute ipv4SrcPrefix.
     *
     * @return ipv4SrcPrefix value of ipv4SrcPrefix
     */
    Ipv4Prefix ipv4SrcPrefix();

    /**
     * Returns the attribute ipv6SrcPrefix.
     *
     * @return ipv6SrcPrefix value of ipv6SrcPrefix
     */
    Ipv6Prefix ipv6SrcPrefix();

    /**
     * Returns the attribute ipv4DstPrefix.
     *
     * @return ipv4DstPrefix value of ipv4DstPrefix
     */
    Ipv4Prefix ipv4DstPrefix();

    /**
     * Returns the attribute ipv6DstPrefix.
     *
     * @return ipv6DstPrefix value of ipv6DstPrefix
     */
    Ipv6Prefix ipv6DstPrefix();

    /**
     * Returns the attribute l4SrcPort.
     *
     * @return l4SrcPort value of l4SrcPort
     */
    int l4SrcPort();

    /**
     * Returns the attribute l4DstPort.
     *
     * @return l4DstPort value of l4DstPort
     */
    int l4DstPort();

    /**
     * Returns the attribute protocolField.
     *
     * @return protocolField value of protocolField
     */
    ProtocolFieldUnion protocolField();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute dscp.
     *
     * @param dscp value of dscp
     */
    void dscp(short dscp);

    /**
     * Sets the attribute tos.
     *
     * @param tos value of tos
     */
    void tos(short tos);

    /**
     * Sets the attribute dot1p.
     *
     * @param dot1p value of dot1p
     */
    void dot1p(short dot1p);

    /**
     * Sets the attribute ipv4SrcPrefix.
     *
     * @param ipv4SrcPrefix value of ipv4SrcPrefix
     */
    void ipv4SrcPrefix(Ipv4Prefix ipv4SrcPrefix);

    /**
     * Sets the attribute ipv6SrcPrefix.
     *
     * @param ipv6SrcPrefix value of ipv6SrcPrefix
     */
    void ipv6SrcPrefix(Ipv6Prefix ipv6SrcPrefix);

    /**
     * Sets the attribute ipv4DstPrefix.
     *
     * @param ipv4DstPrefix value of ipv4DstPrefix
     */
    void ipv4DstPrefix(Ipv4Prefix ipv4DstPrefix);

    /**
     * Sets the attribute ipv6DstPrefix.
     *
     * @param ipv6DstPrefix value of ipv6DstPrefix
     */
    void ipv6DstPrefix(Ipv6Prefix ipv6DstPrefix);

    /**
     * Sets the attribute l4SrcPort.
     *
     * @param l4SrcPort value of l4SrcPort
     */
    void l4SrcPort(int l4SrcPort);

    /**
     * Sets the attribute l4DstPort.
     *
     * @param l4DstPort value of l4DstPort
     */
    void l4DstPort(int l4DstPort);

    /**
     * Sets the attribute protocolField.
     *
     * @param protocolField value of protocolField
     */
    void protocolField(ProtocolFieldUnion protocolField);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}