/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;
/**
 * Represents the implementation of placementDiversity.
 */
public abstract class PlacementDiversity {

    /**
     * Returns the attribute placement-diversity.
     *
     * @return placement-diversity value of placement-diversity
     */
    public static String placementDiversityToString() {
        return "placement-diversity";
    }

    /**
     * Returns the object of placementDiversity fromString input String placementDiversity.
     *
     * @param valInString value of input String
     * @return placementDiversity
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("placement-diversity")) {
            return PlacementDiversity.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}