/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.food.rev20160624.food.food.snack.latenight;

/**
 * Represents ENUM data of chocolateEnum.
 */
public enum ChocolateEnum {

    /**
     * Represents dark.
     */
    DARK(0, "dark"),

    /**
     * Represents milk.
     */
    MILK(1, "milk"),

    /**
     * Represents first-available.
     */
    FIRST_AVAILABLE(2, "first-available");

    private int chocolateEnum;
    private String schemaName;

    /**
     * Creates an instance of chocolateEnum.
     *
     * @param chocolateEnum value of chocolateEnum
     */
     ChocolateEnum(int chocolateEnum, String schemaName) {
        this.chocolateEnum = chocolateEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of chocolateEnum for.
     *
     * @param value value of chocolateEnum for
     * @return chocolateEnum for
     */
    public static ChocolateEnum of(int value) {
        switch (value) {
            case 0:
                return ChocolateEnum.DARK;
            case 1:
                return ChocolateEnum.MILK;
            case 2:
                return ChocolateEnum.FIRST_AVAILABLE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of chocolateEnum for.
     *
     * @param value value of chocolateEnum for
     * @return chocolateEnum for
     */
    public static ChocolateEnum of(String value) {
        switch (value) {
            case "dark":
                return ChocolateEnum.DARK;
            case "milk":
                return ChocolateEnum.MILK;
            case "first-available":
                return ChocolateEnum.FIRST_AVAILABLE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute chocolateEnum.
     *
     * @return chocolateEnum value of chocolateEnum
     */
    public int chocolateEnum() {
        return chocolateEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
