/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont53.
 */
public interface Cont53 extends Augmentable  {

    /**
     * Identify the leaf of Cont53.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf55.
         */
        LEAF55(1),
        /**
         * Represents leaf54.
         */
        LEAF54(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf55.
     *
     * @return leaf55 value of leaf55
     */
    String leaf55();

    /**
     * Returns the attribute leaf54.
     *
     * @return leaf54 list of leaf54
     */
    List<String> leaf54();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute leaf55.
     *
     * @param leaf55 value of leaf55
     */
    void leaf55(String leaf55);

    /**
     * Sets the attribute leaf54.
     *
     * @param leaf54 list of leaf54
     */
    void leaf54(List<String> leaf54);

    /**
     * Adds to the list of leaf54.
     *
     * @param addTo value of leaf54
     */
    void addToLeaf54(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}