/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.ctl.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.onosproject.event.Event;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfDeviceOutputEvent;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.onosproject.netconf.NetconfSessionFactory;
import org.onosproject.netconf.TargetConfig;
import org.onosproject.netconf.ctl.impl.NetconfControllerImpl;
import org.onosproject.netconf.ctl.impl.NetconfSessionDelegate;
import org.onosproject.netconf.ctl.impl.NetconfStreamHandler;
import org.onosproject.netconf.ctl.impl.NetconfStreamThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfSessionMinaImpl
implements NetconfSession {
    private static final Logger log = LoggerFactory.getLogger(NetconfSessionMinaImpl.class);
    private static final String ENDPATTERN = "]]>]]>";
    private static final String MESSAGE_ID_STRING = "message-id";
    private static final String HELLO = "<hello";
    private static final String NEW_LINE = "\n";
    private static final String END_OF_RPC_OPEN_TAG = "\">";
    private static final String EQUAL = "=";
    private static final String NUMBER_BETWEEN_QUOTES_MATCHER = "\"+([0-9]+)+\"";
    private static final String RPC_OPEN = "<rpc ";
    private static final String RPC_CLOSE = "</rpc>";
    private static final String GET_OPEN = "<get>";
    private static final String GET_CLOSE = "</get>";
    private static final String WITH_DEFAULT_OPEN = "<with-defaults ";
    private static final String WITH_DEFAULT_CLOSE = "</with-defaults>";
    private static final String DEFAULT_OPERATION_OPEN = "<default-operation>";
    private static final String DEFAULT_OPERATION_CLOSE = "</default-operation>";
    private static final String SUBTREE_FILTER_OPEN = "<filter type=\"subtree\">";
    private static final String SUBTREE_FILTER_CLOSE = "</filter>";
    private static final String EDIT_CONFIG_OPEN = "<edit-config>";
    private static final String EDIT_CONFIG_CLOSE = "</edit-config>";
    private static final String TARGET_OPEN = "<target>";
    private static final String TARGET_CLOSE = "</target>";
    private static final String CONFIG_OPEN = "<config xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">";
    private static final String CONFIG_CLOSE = "</config>";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String NETCONF_BASE_NAMESPACE = "xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"";
    private static final String NETCONF_WITH_DEFAULTS_NAMESPACE = "xmlns=\"urn:ietf:params:xml:ns:yang:ietf-netconf-with-defaults\"";
    private static final String SUBSCRIPTION_SUBTREE_FILTER_OPEN = "<filter xmlns:base10=\"urn:ietf:params:xml:ns:netconf:base:1.0\" base10:type=\"subtree\">";
    private static final String INTERLEAVE_CAPABILITY_STRING = "urn:ietf:params:netconf:capability:interleave:1.0";
    private static final String CAPABILITY_REGEX = "<capability>\\s*(.*?)\\s*</capability>";
    private static final Pattern CAPABILITY_REGEX_PATTERN = Pattern.compile("<capability>\\s*(.*?)\\s*</capability>");
    private static final String SESSION_ID_REGEX = "<session-id>\\s*(.*?)\\s*</session-id>";
    private static final Pattern SESSION_ID_REGEX_PATTERN = Pattern.compile("<session-id>\\s*(.*?)\\s*</session-id>");
    private static final String RSA = "RSA";
    private static final String DSA = "DSA";
    private String sessionID;
    private final AtomicInteger messageIdInteger = new AtomicInteger(1);
    protected final NetconfDeviceInfo deviceInfo;
    private Iterable<String> onosCapabilities = Collections.singletonList("urn:ietf:params:netconf:base:1.0");
    @Deprecated
    private String serverHelloResponseOld;
    private final Set<String> deviceCapabilities = new LinkedHashSet<String>();
    private NetconfStreamHandler streamHandler;
    private Map<Integer, CompletableFuture<String>> replies;
    private List<String> errorReplies;
    private boolean subscriptionConnected = false;
    private String notificationFilterSchema = null;
    private final Collection<NetconfDeviceOutputEventListener> primaryListeners = new CopyOnWriteArrayList<NetconfDeviceOutputEventListener>();
    private final Collection<NetconfSession> children = new CopyOnWriteArrayList<NetconfSession>();
    private ClientChannel channel = null;
    private ClientSession session = null;
    private SshClient client = null;

    public NetconfSessionMinaImpl(NetconfDeviceInfo deviceInfo) throws NetconfException {
        this.deviceInfo = deviceInfo;
        this.replies = new ConcurrentHashMap<Integer, CompletableFuture<String>>();
        this.errorReplies = new ArrayList<String>();
        this.startConnection();
    }

    private void startConnection() throws NetconfException {
        try {
            this.startClient();
        }
        catch (IOException e) {
            throw new NetconfException("Failed to establish SSH with device " + this.deviceInfo, (Throwable)e);
        }
    }

    private void startClient() throws IOException {
        this.client = SshClient.setUpDefaultClient();
        this.client.start();
        this.client.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        this.startSession();
    }

    private void startSession() throws IOException {
        ConnectFuture connectFuture = (ConnectFuture)this.client.connect(this.deviceInfo.name(), this.deviceInfo.ip().toString(), this.deviceInfo.port()).verify((long)NetconfControllerImpl.netconfConnectTimeout, TimeUnit.SECONDS);
        this.session = connectFuture.getSession();
        if (this.deviceInfo.getKey() != null) {
            PublicKey key;
            ByteBuffer buf = StandardCharsets.UTF_8.encode(CharBuffer.wrap(this.deviceInfo.getKey()));
            byte[] byteKey = new byte[buf.limit()];
            buf.get(byteKey);
            try {
                key = this.getPublicKey(byteKey, RSA);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                try {
                    key = this.getPublicKey(byteKey, DSA);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e1) {
                    throw new NetconfException("Failed to authenticate session with device " + this.deviceInfo + "check key to be the proper DSA or RSA key", (Throwable)e1);
                }
            }
            this.session.addPublicKeyIdentity(new KeyPair(key, null));
        } else {
            this.session.addPasswordIdentity(this.deviceInfo.password());
        }
        this.session.auth().verify((long)NetconfControllerImpl.netconfConnectTimeout, TimeUnit.SECONDS);
        Set event = this.session.waitFor((Collection)ImmutableSet.of((Object)ClientSession.ClientSessionEvent.WAIT_AUTH, (Object)ClientSession.ClientSessionEvent.CLOSED, (Object)ClientSession.ClientSessionEvent.AUTHED), 0L);
        if (!event.contains(ClientSession.ClientSessionEvent.AUTHED)) {
            log.debug("Session closed {} {}", (Object)event, (Object)this.session.isClosed());
            throw new NetconfException("Failed to authenticate session with device " + this.deviceInfo + "check the user/pwd or key");
        }
        this.openChannel();
    }

    private PublicKey getPublicKey(byte[] keyBytes, String type) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(type);
        return kf.generatePublic(spec);
    }

    private void openChannel() throws IOException {
        this.channel = this.session.createSubsystemChannel("netconf");
        OpenFuture channelFuture = this.channel.open();
        if (channelFuture.await((long)NetconfControllerImpl.netconfConnectTimeout, TimeUnit.SECONDS)) {
            if (!channelFuture.isOpened()) {
                throw new NetconfException("Failed to open channel with device " + this.deviceInfo);
            }
            this.streamHandler = new NetconfStreamThread(this.channel.getInvertedOut(), this.channel.getInvertedIn(), this.channel.getInvertedErr(), this.deviceInfo, new NetconfSessionDelegateImpl(), this.replies);
            this.sendHello();
        }
    }

    @Beta
    protected void startSubscriptionStream(String filterSchema) throws NetconfException {
        boolean openNewSession = false;
        if (!this.deviceCapabilities.contains(INTERLEAVE_CAPABILITY_STRING)) {
            log.info("Device {} doesn't support interleave, creating child session", (Object)this.deviceInfo);
            openNewSession = true;
        } else if (this.subscriptionConnected && this.notificationFilterSchema != null && !Objects.equal((Object)filterSchema, (Object)this.notificationFilterSchema)) {
            log.info("Cannot use existing session for subscription {} ({})", (Object)this.deviceInfo, (Object)filterSchema);
            openNewSession = true;
        }
        if (openNewSession) {
            log.info("Creating notification session to {} with filter {}", (Object)this.deviceInfo, (Object)filterSchema);
            NotificationSession child = new NotificationSession(this.deviceInfo);
            child.addDeviceOutputListener(new NotificationForwarder());
            child.startSubscription(filterSchema);
            this.children.add(child);
            return;
        }
        String reply = this.sendRequest(this.createSubscriptionString(filterSchema));
        if (!this.checkReply(reply)) {
            throw new NetconfException("Subscription not successful with device " + this.deviceInfo + " with reply " + reply);
        }
        this.subscriptionConnected = true;
    }

    public void startSubscription() throws NetconfException {
        if (!this.subscriptionConnected) {
            this.startSubscriptionStream(null);
        }
        this.streamHandler.setEnableNotifications(true);
    }

    @Beta
    public void startSubscription(String filterSchema) throws NetconfException {
        if (!this.subscriptionConnected) {
            this.notificationFilterSchema = filterSchema;
            this.startSubscriptionStream(filterSchema);
        }
        this.streamHandler.setEnableNotifications(true);
    }

    @Beta
    protected String createSubscriptionString(String filterSchema) {
        StringBuilder subscriptionbuffer = new StringBuilder();
        subscriptionbuffer.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        subscriptionbuffer.append("  <create-subscription\n");
        subscriptionbuffer.append("xmlns=\"urn:ietf:params:xml:ns:netconf:notification:1.0\">\n");
        if (filterSchema != null) {
            subscriptionbuffer.append("    ");
            subscriptionbuffer.append(SUBSCRIPTION_SUBTREE_FILTER_OPEN).append(NEW_LINE);
            subscriptionbuffer.append(filterSchema).append(NEW_LINE);
            subscriptionbuffer.append("    ");
            subscriptionbuffer.append(SUBTREE_FILTER_CLOSE).append(NEW_LINE);
        }
        subscriptionbuffer.append("  </create-subscription>\n");
        subscriptionbuffer.append("</rpc>\n");
        subscriptionbuffer.append(ENDPATTERN);
        return subscriptionbuffer.toString();
    }

    public void endSubscription() throws NetconfException {
        if (!this.subscriptionConnected) {
            throw new NetconfException("Subscription does not exist.");
        }
        this.streamHandler.setEnableNotifications(false);
    }

    private void sendHello() throws NetconfException {
        this.serverHelloResponseOld = this.sendRequest(this.createHelloString(), true);
        Matcher capabilityMatcher = CAPABILITY_REGEX_PATTERN.matcher(this.serverHelloResponseOld);
        while (capabilityMatcher.find()) {
            this.deviceCapabilities.add(capabilityMatcher.group(1));
        }
        this.sessionID = String.valueOf(-1);
        Matcher sessionIDMatcher = SESSION_ID_REGEX_PATTERN.matcher(this.serverHelloResponseOld);
        if (!sessionIDMatcher.find()) {
            throw new NetconfException("Missing SessionID in server hello reponse.");
        }
        this.sessionID = sessionIDMatcher.group(1);
    }

    private String createHelloString() {
        StringBuilder hellobuffer = new StringBuilder();
        hellobuffer.append(XML_HEADER);
        hellobuffer.append(NEW_LINE);
        hellobuffer.append("<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        hellobuffer.append("  <capabilities>\n");
        this.onosCapabilities.forEach(cap -> hellobuffer.append("    <capability>").append((String)cap).append("</capability>\n"));
        hellobuffer.append("  </capabilities>\n");
        hellobuffer.append("</hello>\n");
        hellobuffer.append(ENDPATTERN);
        return hellobuffer.toString();
    }

    public void checkAndReestablish() throws NetconfException {
        try {
            if (this.client.isClosed()) {
                log.debug("Trying to restart the whole SSH connection with {}", (Object)this.deviceInfo.getDeviceId());
                this.cleanUp();
                this.startConnection();
            } else if (this.session.isClosed()) {
                log.debug("Trying to restart the session with {}", (Object)this.session, (Object)this.deviceInfo.getDeviceId());
                this.cleanUp();
                this.startSession();
            } else if (this.channel.isClosed()) {
                log.debug("Trying to reopen the channel with {}", (Object)this.deviceInfo.getDeviceId());
                this.cleanUp();
                this.openChannel();
            }
            if (this.subscriptionConnected) {
                log.debug("Restarting subscription with {}", (Object)this.deviceInfo.getDeviceId());
                this.subscriptionConnected = false;
                this.startSubscription(this.notificationFilterSchema);
            }
        }
        catch (IOException e) {
            log.error("Can't reopen connection for device {}", (Object)e.getMessage());
            throw new NetconfException("Cannot re-open the connection with device" + this.deviceInfo, (Throwable)e);
        }
    }

    private void cleanUp() {
        this.replies.clear();
    }

    public String requestSync(String request) throws NetconfException {
        if (!request.contains(ENDPATTERN)) {
            request = request + NEW_LINE + ENDPATTERN;
        }
        String reply = this.sendRequest(request);
        this.checkReply(reply);
        return reply;
    }

    @Deprecated
    public CompletableFuture<String> request(String request) {
        return this.streamHandler.sendMessage(request);
    }

    private CompletableFuture<String> request(String request, int messageId) {
        return this.streamHandler.sendMessage(request, messageId);
    }

    private String sendRequest(String request) throws NetconfException {
        return this.sendRequest(request, false);
    }

    private String sendRequest(String request, boolean isHello) throws NetconfException {
        String rp;
        this.checkAndReestablish();
        int messageId = -1;
        if (!isHello) {
            messageId = this.messageIdInteger.getAndIncrement();
        }
        request = this.formatRequestMessageId(request, messageId);
        request = this.formatXmlHeader(request);
        CompletableFuture<String> futureReply = this.request(request, messageId);
        int replyTimeout = NetconfControllerImpl.netconfReplyTimeout;
        try {
            rp = futureReply.get(replyTimeout, TimeUnit.SECONDS);
            this.replies.remove(messageId);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new NetconfException("No matching reply for request " + request, (Throwable)e);
        }
        log.debug("Result {} from request {} to device {}", new Object[]{rp, request, this.deviceInfo});
        return rp.trim();
    }

    private String formatRequestMessageId(String request, int messageId) {
        if (request.contains(MESSAGE_ID_STRING)) {
            request = request.replaceFirst("message-id=\"+([0-9]+)+\"", "message-id=\"" + messageId + "\"");
        } else if (!request.contains(MESSAGE_ID_STRING) && !request.contains(HELLO)) {
            request = request.replaceFirst(END_OF_RPC_OPEN_TAG, "\" message-id=\"" + messageId + END_OF_RPC_OPEN_TAG);
        }
        return request;
    }

    private String formatXmlHeader(String request) {
        if (!request.contains(XML_HEADER)) {
            request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + request;
        }
        return request;
    }

    public String doWrappedRpc(String request) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append(request);
        rpc.append(RPC_CLOSE).append(NEW_LINE);
        rpc.append(ENDPATTERN);
        String reply = this.sendRequest(rpc.toString());
        this.checkReply(reply);
        return reply;
    }

    public String get(String request) throws NetconfException {
        return this.requestSync(request);
    }

    public String get(String filterSchema, String withDefaultsMode) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append(GET_OPEN).append(NEW_LINE);
        if (filterSchema != null) {
            rpc.append(SUBTREE_FILTER_OPEN).append(NEW_LINE);
            rpc.append(filterSchema).append(NEW_LINE);
            rpc.append(SUBTREE_FILTER_CLOSE).append(NEW_LINE);
        }
        if (withDefaultsMode != null) {
            rpc.append(WITH_DEFAULT_OPEN).append(NETCONF_WITH_DEFAULTS_NAMESPACE).append(">");
            rpc.append(withDefaultsMode).append(WITH_DEFAULT_CLOSE).append(NEW_LINE);
        }
        rpc.append(GET_CLOSE).append(NEW_LINE);
        rpc.append(RPC_CLOSE).append(NEW_LINE);
        rpc.append(ENDPATTERN);
        String reply = this.sendRequest(rpc.toString());
        this.checkReply(reply);
        return reply;
    }

    public String getConfig(TargetConfig netconfTargetConfig) throws NetconfException {
        return this.getConfig(netconfTargetConfig, null);
    }

    public String getConfig(String netconfTargetConfig) throws NetconfException {
        return this.getConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig));
    }

    public String getConfig(String netconfTargetConfig, String configurationFilterSchema) throws NetconfException {
        return this.getConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig), configurationFilterSchema);
    }

    public String getConfig(TargetConfig netconfTargetConfig, String configurationSchema) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append("xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        rpc.append("<get-config>\n");
        rpc.append("<source>\n");
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append("</source>");
        if (configurationSchema != null) {
            rpc.append("<filter type=\"subtree\">\n");
            rpc.append(configurationSchema).append(NEW_LINE);
            rpc.append("</filter>\n");
        }
        rpc.append("</get-config>\n");
        rpc.append("</rpc>\n");
        rpc.append(ENDPATTERN);
        String reply = this.sendRequest(rpc.toString());
        return this.checkReply(reply) ? reply : "ERROR " + reply;
    }

    public boolean editConfig(String newConfiguration) throws NetconfException {
        newConfiguration = newConfiguration + ENDPATTERN;
        return this.checkReply(this.sendRequest(newConfiguration));
    }

    public boolean editConfig(String netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        return this.editConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig), mode, newConfiguration);
    }

    public boolean editConfig(TargetConfig netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        newConfiguration = newConfiguration.trim();
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append(EDIT_CONFIG_OPEN).append(NEW_LINE);
        rpc.append(TARGET_OPEN);
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append(TARGET_CLOSE).append(NEW_LINE);
        if (mode != null) {
            rpc.append(DEFAULT_OPERATION_OPEN);
            rpc.append(mode);
            rpc.append(DEFAULT_OPERATION_CLOSE).append(NEW_LINE);
        }
        rpc.append(CONFIG_OPEN).append(NEW_LINE);
        rpc.append(newConfiguration);
        rpc.append(CONFIG_CLOSE).append(NEW_LINE);
        rpc.append(EDIT_CONFIG_CLOSE).append(NEW_LINE);
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        log.debug(rpc.toString());
        String reply = this.sendRequest(rpc.toString());
        return this.checkReply(reply);
    }

    public boolean copyConfig(String netconfTargetConfig, String newConfiguration) throws NetconfException {
        return this.copyConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig), newConfiguration);
    }

    public boolean copyConfig(TargetConfig netconfTargetConfig, String newConfiguration) throws NetconfException {
        if (!(newConfiguration = newConfiguration.trim()).startsWith("<config>")) {
            newConfiguration = "<config>" + newConfiguration + CONFIG_CLOSE;
        }
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append("<copy-config>");
        rpc.append(TARGET_OPEN);
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("<source>");
        rpc.append(newConfiguration);
        rpc.append("</source>");
        rpc.append("</copy-config>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        return this.checkReply(this.sendRequest(rpc.toString()));
    }

    public boolean deleteConfig(String netconfTargetConfig) throws NetconfException {
        return this.deleteConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig));
    }

    public boolean deleteConfig(TargetConfig netconfTargetConfig) throws NetconfException {
        if (netconfTargetConfig.equals((Object)TargetConfig.RUNNING)) {
            log.warn("Target configuration for delete operation can't be \"running\"", (Object)netconfTargetConfig);
            return false;
        }
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append("<rpc>");
        rpc.append("<delete-config>");
        rpc.append(TARGET_OPEN);
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("</delete-config>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        return this.checkReply(this.sendRequest(rpc.toString()));
    }

    public boolean lock(String configType) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        rpc.append("<lock>");
        rpc.append(TARGET_OPEN);
        rpc.append("<");
        rpc.append(configType);
        rpc.append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("</lock>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        String lockReply = this.sendRequest(rpc.toString());
        return this.checkReply(lockReply);
    }

    public boolean unlock(String configType) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        rpc.append("<unlock>");
        rpc.append(TARGET_OPEN);
        rpc.append("<");
        rpc.append(configType);
        rpc.append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("</unlock>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        String unlockReply = this.sendRequest(rpc.toString());
        return this.checkReply(unlockReply);
    }

    public boolean lock() throws NetconfException {
        return this.lock("running");
    }

    public boolean unlock() throws NetconfException {
        return this.unlock("running");
    }

    public boolean close() throws NetconfException {
        return this.close(false);
    }

    private boolean close(boolean force) throws NetconfException {
        StringBuilder rpc = new StringBuilder();
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        if (force) {
            rpc.append("<kill-session/>");
        } else {
            rpc.append("<close-session/>");
        }
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        return this.checkReply(this.sendRequest(rpc.toString())) || this.close(true);
    }

    public String getSessionId() {
        return this.sessionID;
    }

    public Set<String> getDeviceCapabilitiesSet() {
        return Collections.unmodifiableSet(this.deviceCapabilities);
    }

    @Deprecated
    public String getServerCapabilities() {
        return this.serverHelloResponseOld;
    }

    @Deprecated
    public void setDeviceCapabilities(List<String> capabilities) {
        this.onosCapabilities = capabilities;
    }

    public void setOnosCapabilities(Iterable<String> capabilities) {
        this.onosCapabilities = capabilities;
    }

    public void addDeviceOutputListener(NetconfDeviceOutputEventListener listener) {
        this.streamHandler.addDeviceEventListener(listener);
        this.primaryListeners.add(listener);
    }

    public void removeDeviceOutputListener(NetconfDeviceOutputEventListener listener) {
        this.primaryListeners.remove(listener);
        this.streamHandler.removeDeviceEventListener(listener);
    }

    private boolean checkReply(String reply) throws NetconfException {
        if (reply != null) {
            if (!reply.contains("<rpc-error>")) {
                log.debug("Device {} sent reply {}", (Object)this.deviceInfo, (Object)reply);
                return true;
            }
            if (reply.contains("<ok/>") || reply.contains("<rpc-error>") && reply.contains("warning")) {
                log.debug("Device {} sent reply {}", (Object)this.deviceInfo, (Object)reply);
                return true;
            }
        }
        log.warn("Device {} has error in reply {}", (Object)this.deviceInfo, (Object)reply);
        return false;
    }

    public static class MinaSshNetconfSessionFactory
    implements NetconfSessionFactory {
        public NetconfSession createNetconfSession(NetconfDeviceInfo netconfDeviceInfo) throws NetconfException {
            return new NetconfSessionMinaImpl(netconfDeviceInfo);
        }
    }

    public class NetconfSessionDelegateImpl
    implements NetconfSessionDelegate {
        @Override
        public void notify(NetconfDeviceOutputEvent event) {
            Optional messageId = event.getMessageID();
            log.debug("messageID {}, waiting replies messageIDs {}", (Object)messageId, NetconfSessionMinaImpl.this.replies.keySet());
            if (!messageId.isPresent()) {
                NetconfSessionMinaImpl.this.errorReplies.add(event.getMessagePayload());
                log.error("Device {} sent error reply {}", (Object)event.getDeviceInfo(), (Object)event.getMessagePayload());
                return;
            }
            CompletableFuture completedReply = (CompletableFuture)NetconfSessionMinaImpl.this.replies.get(messageId.get());
            if (completedReply != null) {
                completedReply.complete(event.getMessagePayload());
            }
        }
    }

    private final class NotificationForwarder
    implements NetconfDeviceOutputEventListener {
        private NotificationForwarder() {
        }

        public boolean isRelevant(NetconfDeviceOutputEvent event) {
            return event.type() == NetconfDeviceOutputEvent.Type.DEVICE_NOTIFICATION;
        }

        public void event(NetconfDeviceOutputEvent event) {
            NetconfSessionMinaImpl.this.primaryListeners.forEach(lsnr -> {
                if (lsnr.isRelevant((Event)event)) {
                    lsnr.event((Event)event);
                }
            });
        }
    }

    static class NotificationSession
    extends NetconfSessionMinaImpl {
        private String notificationFilter;

        NotificationSession(NetconfDeviceInfo deviceInfo) throws NetconfException {
            super(deviceInfo);
        }

        @Override
        protected void startSubscriptionStream(String filterSchema) throws NetconfException {
            this.notificationFilter = filterSchema;
            this.requestSync(this.createSubscriptionString(filterSchema));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("deviceInfo", (Object)this.deviceInfo).add("sessionID", (Object)this.getSessionId()).add("notificationFilter", (Object)this.notificationFilter).toString();
        }
    }
}

