/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.ctl.impl;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyService;
import org.onosproject.net.key.UsernamePassword;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfDeviceFactory;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfDeviceListener;
import org.onosproject.netconf.NetconfDeviceOutputEvent;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.ctl.impl.DefaultNetconfDevice;
import org.onosproject.netconf.ctl.impl.NetconfSessionImpl;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class NetconfControllerImpl
implements NetconfController {
    private static final String ETHZ_SSH2 = "ethz-ssh2";
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 5;
    private static final String PROP_NETCONF_CONNECT_TIMEOUT = "netconfConnectTimeout";
    @Property(name="netconfConnectTimeout", intValue={5}, label="Time (in seconds) to wait for a NETCONF connect.")
    protected static int netconfConnectTimeout = 5;
    private static final String PROP_NETCONF_REPLY_TIMEOUT = "netconfReplyTimeout";
    private static final int DEFAULT_REPLY_TIMEOUT_SECONDS = 5;
    @Property(name="netconfReplyTimeout", intValue={5}, label="Time (in seconds) waiting for a NetConf reply")
    protected static int netconfReplyTimeout = 5;
    private static final String SSH_LIBRARY = "sshLibrary";
    private static final String APACHE_MINA = "apache_mina";
    @Property(name="sshLibrary", value={"apache_mina"}, label="Ssh Llbrary instead of Apache Mina (i.e. ethz-ssh2")
    protected static String sshLibrary = "apache_mina";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceKeyService deviceKeyService;
    public static final Logger log = LoggerFactory.getLogger(NetconfControllerImpl.class);
    private Map<DeviceId, NetconfDevice> netconfDeviceMap = new ConcurrentHashMap<DeviceId, NetconfDevice>();
    private final NetconfDeviceOutputEventListener downListener = new DeviceDownEventListener();
    protected Set<NetconfDeviceListener> netconfDeviceListeners = new CopyOnWriteArraySet<NetconfDeviceListener>();
    protected NetconfDeviceFactory deviceFactory = new DefaultNetconfDeviceFactory();
    protected final ExecutorService executor = Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/netconfdevicecontroller", (String)"connection-reopen-%d", (Logger)log));

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.modified(context);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.netconfDeviceMap.values().forEach(device -> {
            device.getSession().removeDeviceOutputListener(this.downListener);
            device.disconnect();
        });
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.netconfDeviceListeners.clear();
        this.netconfDeviceMap.clear();
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        String newSshLibrary;
        int newNetconfConnectTimeout;
        int newNetconfReplyTimeout;
        if (context == null) {
            netconfReplyTimeout = 5;
            netconfConnectTimeout = 5;
            sshLibrary = APACHE_MINA;
            log.info("No component configuration");
            return;
        }
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)PROP_NETCONF_REPLY_TIMEOUT);
            newNetconfReplyTimeout = Strings.isNullOrEmpty((String)s) ? netconfReplyTimeout : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)PROP_NETCONF_CONNECT_TIMEOUT);
            newNetconfConnectTimeout = Strings.isNullOrEmpty((String)s) ? netconfConnectTimeout : Integer.parseInt(s.trim());
            newSshLibrary = Tools.get((Dictionary)properties, (String)SSH_LIBRARY);
        }
        catch (NumberFormatException e) {
            log.warn("Component configuration had invalid value", (Throwable)e);
            return;
        }
        if (newNetconfConnectTimeout < 0) {
            log.warn("netconfConnectTimeout is invalid - less than 0");
            return;
        }
        if (newNetconfReplyTimeout <= 0) {
            log.warn("netconfReplyTimeout is invalid - 0 or less.");
            return;
        }
        netconfReplyTimeout = newNetconfReplyTimeout;
        netconfConnectTimeout = newNetconfConnectTimeout;
        sshLibrary = newSshLibrary;
        log.info("Settings: {} = {}, {} = {}, {} = {}", new Object[]{PROP_NETCONF_REPLY_TIMEOUT, netconfReplyTimeout, PROP_NETCONF_CONNECT_TIMEOUT, netconfConnectTimeout, SSH_LIBRARY, sshLibrary});
    }

    public void addDeviceListener(NetconfDeviceListener listener) {
        if (!this.netconfDeviceListeners.contains(listener)) {
            this.netconfDeviceListeners.add(listener);
        }
    }

    public void removeDeviceListener(NetconfDeviceListener listener) {
        this.netconfDeviceListeners.remove(listener);
    }

    public NetconfDevice getNetconfDevice(DeviceId deviceInfo) {
        return this.netconfDeviceMap.get(deviceInfo);
    }

    public NetconfDevice getNetconfDevice(IpAddress ip, int port) {
        for (DeviceId info : this.netconfDeviceMap.keySet()) {
            if (!info.uri().getSchemeSpecificPart().equals(ip.toString() + ":" + port)) continue;
            return this.netconfDeviceMap.get(info);
        }
        return null;
    }

    public NetconfDevice connectDevice(DeviceId deviceId) throws NetconfException {
        int port;
        String ip;
        if (this.netconfDeviceMap.containsKey(deviceId)) {
            log.debug("Device {} is already present", (Object)deviceId);
            return this.netconfDeviceMap.get(deviceId);
        }
        log.debug("Creating NETCONF device {}", (Object)deviceId);
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null) {
            ip = device.annotations().value("ipaddress");
            port = Integer.parseInt(device.annotations().value("port"));
        } else {
            String[] info = deviceId.toString().split(":");
            if (info.length == 3) {
                ip = info[1];
                port = Integer.parseInt(info[2]);
            } else {
                ip = Arrays.asList(info).stream().filter(el -> !el.equals(info[0]) && !el.equals(info[info.length - 1])).reduce((t, u) -> t + ":" + u).get();
                log.debug("ip v6 {}", (Object)ip);
                port = Integer.parseInt(info[info.length - 1]);
            }
        }
        try {
            DeviceKey deviceKey = this.deviceKeyService.getDeviceKey(DeviceKeyId.deviceKeyId((String)deviceId.toString()));
            NetconfDeviceInfo deviceInfo = null;
            if (deviceKey.type() == DeviceKey.Type.USERNAME_PASSWORD) {
                UsernamePassword usernamepasswd = deviceKey.asUsernamePassword();
                deviceInfo = new NetconfDeviceInfo(usernamepasswd.username(), usernamepasswd.password(), IpAddress.valueOf((String)ip), port);
            } else if (deviceKey.type() == DeviceKey.Type.SSL_KEY) {
                String username = deviceKey.annotations().value("username");
                String password = deviceKey.annotations().value("password");
                String sshkey = deviceKey.annotations().value("sshkey");
                deviceInfo = new NetconfDeviceInfo(username, password, IpAddress.valueOf((String)ip), port, sshkey);
            } else {
                log.error("Unknown device key for device {}", (Object)deviceId);
            }
            NetconfDevice netconfDevicedevice = this.createDevice(deviceInfo);
            netconfDevicedevice.getSession().addDeviceOutputListener(this.downListener);
            return netconfDevicedevice;
        }
        catch (NullPointerException e) {
            throw new NetconfException("No Device Key for device " + deviceId, (Throwable)e);
        }
    }

    public void disconnectDevice(DeviceId deviceId, boolean remove) {
        if (!this.netconfDeviceMap.containsKey(deviceId)) {
            log.warn("Device {} is not present", (Object)deviceId);
        } else {
            this.stopDevice(deviceId, remove);
        }
    }

    private void stopDevice(DeviceId deviceId, boolean remove) {
        this.netconfDeviceMap.get(deviceId).disconnect();
        this.netconfDeviceMap.remove(deviceId);
        if (remove) {
            for (NetconfDeviceListener l : this.netconfDeviceListeners) {
                l.deviceRemoved(deviceId);
            }
        }
    }

    public void removeDevice(DeviceId deviceId) {
        if (!this.netconfDeviceMap.containsKey(deviceId)) {
            log.warn("Device {} is not present", (Object)deviceId);
            for (NetconfDeviceListener l : this.netconfDeviceListeners) {
                l.deviceRemoved(deviceId);
            }
        } else {
            this.netconfDeviceMap.remove(deviceId);
            for (NetconfDeviceListener l : this.netconfDeviceListeners) {
                l.deviceRemoved(deviceId);
            }
        }
    }

    private NetconfDevice createDevice(NetconfDeviceInfo deviceInfo) throws NetconfException {
        NetconfDevice netconfDevice = this.deviceFactory.createNetconfDevice(deviceInfo);
        this.netconfDeviceMap.put(deviceInfo.getDeviceId(), netconfDevice);
        for (NetconfDeviceListener l : this.netconfDeviceListeners) {
            l.deviceAdded(deviceInfo.getDeviceId());
        }
        return netconfDevice;
    }

    public Map<DeviceId, NetconfDevice> getDevicesMap() {
        return this.netconfDeviceMap;
    }

    public Set<DeviceId> getNetconfDevices() {
        return this.netconfDeviceMap.keySet();
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDeviceKeyService(DeviceKeyService deviceKeyService) {
        this.deviceKeyService = deviceKeyService;
    }

    protected void unbindDeviceKeyService(DeviceKeyService deviceKeyService) {
        if (this.deviceKeyService == deviceKeyService) {
            this.deviceKeyService = null;
        }
    }

    private class DeviceDownEventListener
    implements NetconfDeviceOutputEventListener {
        private DeviceDownEventListener() {
        }

        public void event(NetconfDeviceOutputEvent event) {
            DeviceId did = event.getDeviceInfo().getDeviceId();
            if (((NetconfDeviceOutputEvent.Type)event.type()).equals((Object)NetconfDeviceOutputEvent.Type.DEVICE_UNREGISTERED)) {
                NetconfControllerImpl.this.removeDevice(did);
            } else if (((NetconfDeviceOutputEvent.Type)event.type()).equals((Object)NetconfDeviceOutputEvent.Type.SESSION_CLOSED)) {
                log.info("Trying to reestablish connection with device {}", (Object)did);
                NetconfControllerImpl.this.executor.execute(() -> {
                    try {
                        NetconfDevice device = (NetconfDevice)NetconfControllerImpl.this.netconfDeviceMap.get(did);
                        if (device != null) {
                            device.getSession().checkAndReestablish();
                            log.info("Connection with device {} was reestablished", (Object)did);
                        } else {
                            log.warn("The device {} is not in the system", (Object)did);
                        }
                    }
                    catch (NetconfException e) {
                        log.error("The SSH connection with device {} couldn't be reestablished due to {}. Marking the device as unreachable", (Object)e.getMessage());
                        log.debug("Complete exception: ", (Throwable)e);
                        NetconfControllerImpl.this.removeDevice(did);
                    }
                });
            }
        }

        public boolean isRelevant(NetconfDeviceOutputEvent event) {
            return NetconfControllerImpl.this.getDevicesMap().containsKey(event.getDeviceInfo().getDeviceId());
        }
    }

    private class DefaultNetconfDeviceFactory
    implements NetconfDeviceFactory {
        private DefaultNetconfDeviceFactory() {
        }

        public NetconfDevice createNetconfDevice(NetconfDeviceInfo netconfDeviceInfo) throws NetconfException {
            if (sshLibrary.equals(NetconfControllerImpl.ETHZ_SSH2)) {
                return new DefaultNetconfDevice(netconfDeviceInfo, new NetconfSessionImpl.SshNetconfSessionFactory());
            }
            return new DefaultNetconfDevice(netconfDeviceInfo);
        }
    }
}

