/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.ctl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onosproject.event.Event;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfDeviceOutputEvent;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.ctl.NetconfSessionDelegate;
import org.onosproject.netconf.ctl.NetconfStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NetconfStreamThread
extends Thread
implements NetconfStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(NetconfStreamThread.class);
    private static final String HELLO = "<hello";
    private static final String END_PATTERN = "]]>]]>";
    private static final String RPC_REPLY = "rpc-reply";
    private static final String RPC_ERROR = "rpc-error";
    private static final String NOTIFICATION_LABEL = "<notification";
    private static final String MESSAGE_ID = "message-id=";
    private static final Pattern MSGID_PATTERN = Pattern.compile("message-id=\"(\\d+)\"");
    private PrintWriter outputStream;
    private final InputStream err;
    private final InputStream in;
    private NetconfDeviceInfo netconfDeviceInfo;
    private NetconfSessionDelegate sessionDelegate;
    private NetconfMessageState state;
    private List<NetconfDeviceOutputEventListener> netconfDeviceEventListeners = Lists.newCopyOnWriteArrayList();
    private boolean enableNotifications = true;
    private Map<Integer, CompletableFuture<String>> replies;

    public NetconfStreamThread(InputStream in, OutputStream out, InputStream err, NetconfDeviceInfo deviceInfo, NetconfSessionDelegate delegate, Map<Integer, CompletableFuture<String>> replies) {
        this.in = in;
        this.err = err;
        this.outputStream = new PrintWriter(out);
        this.netconfDeviceInfo = deviceInfo;
        this.state = NetconfMessageState.NO_MATCHING_PATTERN;
        this.sessionDelegate = delegate;
        this.replies = replies;
        log.debug("Stream thread for device {} session started", (Object)deviceInfo);
        this.start();
    }

    @Override
    public CompletableFuture<String> sendMessage(String request) {
        Optional<Integer> messageId = NetconfStreamThread.getMsgId(request);
        return this.sendMessage(request, messageId.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<String> sendMessage(String request, int messageId) {
        log.debug("Sending message {} to device {}", (Object)request, (Object)this.netconfDeviceInfo);
        CompletableFuture<String> cf = new CompletableFuture<String>();
        this.replies.put(messageId, cf);
        PrintWriter printWriter = this.outputStream;
        synchronized (printWriter) {
            this.outputStream.print(request);
            this.outputStream.flush();
        }
        return cf;
    }

    @Override
    public void run() {
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(this.in));
        try {
            boolean socketClosed = false;
            StringBuilder deviceReplyBuilder = new StringBuilder();
            while (!socketClosed) {
                NetconfDeviceOutputEvent event;
                int cInt = bufferReader.read();
                if (cInt == -1) {
                    log.debug("Netconf device {}  sent error char in session, will need to be reopend", (Object)this.netconfDeviceInfo);
                    NetconfDeviceOutputEvent event2 = new NetconfDeviceOutputEvent(NetconfDeviceOutputEvent.Type.SESSION_CLOSED, null, null, Optional.of(-1), this.netconfDeviceInfo);
                    this.netconfDeviceEventListeners.forEach(listener -> listener.event((Event)event2));
                    socketClosed = true;
                    log.debug("Netconf device {} ERROR cInt == -1 socketClosed = true", (Object)this.netconfDeviceInfo);
                }
                char c = (char)cInt;
                this.state = this.state.evaluateChar(c);
                deviceReplyBuilder.append(c);
                if (this.state != NetconfMessageState.END_PATTERN) continue;
                String deviceReply = deviceReplyBuilder.toString();
                if (deviceReply.equals(END_PATTERN)) {
                    socketClosed = true;
                    log.debug("Netconf device {} socketClosed = true DEVICE_UNREGISTERED {}", (Object)this.netconfDeviceInfo, (Object)deviceReply);
                    event = new NetconfDeviceOutputEvent(NetconfDeviceOutputEvent.Type.DEVICE_UNREGISTERED, null, null, Optional.of(-1), this.netconfDeviceInfo);
                    this.netconfDeviceEventListeners.forEach(listener -> listener.event((Event)event));
                    this.interrupt();
                    continue;
                }
                if ((deviceReply = deviceReply.replace(END_PATTERN, "")).contains(RPC_REPLY) || deviceReply.contains(RPC_ERROR) || deviceReply.contains(HELLO)) {
                    log.debug("Netconf device {} sessionDelegate.notify() DEVICE_REPLY {} {}", new Object[]{this.netconfDeviceInfo, NetconfStreamThread.getMsgId(deviceReply), deviceReply});
                    event = new NetconfDeviceOutputEvent(NetconfDeviceOutputEvent.Type.DEVICE_REPLY, null, deviceReply, NetconfStreamThread.getMsgId(deviceReply), this.netconfDeviceInfo);
                    this.sessionDelegate.notify(event);
                    this.netconfDeviceEventListeners.forEach(listener -> listener.event((Event)event));
                } else if (deviceReply.contains(NOTIFICATION_LABEL)) {
                    log.debug("Netconf device {} DEVICE_NOTIFICATION {} {} {}", new Object[]{this.netconfDeviceInfo, this.enableNotifications, NetconfStreamThread.getMsgId(deviceReply), deviceReply});
                    if (this.enableNotifications) {
                        log.debug("dispatching to {} listeners", (Object)this.netconfDeviceEventListeners.size());
                        String finalDeviceReply = deviceReply;
                        this.netconfDeviceEventListeners.forEach(listener -> listener.event((Event)new NetconfDeviceOutputEvent(NetconfDeviceOutputEvent.Type.DEVICE_NOTIFICATION, null, finalDeviceReply, NetconfStreamThread.getMsgId(finalDeviceReply), this.netconfDeviceInfo)));
                    }
                } else {
                    log.debug("Error on reply from device {} {}", (Object)this.netconfDeviceInfo, (Object)deviceReply);
                }
                deviceReplyBuilder.setLength(0);
            }
        }
        catch (IOException e) {
            log.warn("Error in reading from the session for device {} ", (Object)this.netconfDeviceInfo, (Object)e);
            throw new RuntimeException(new NetconfException("Error in reading from the session for device {}" + this.netconfDeviceInfo, (Throwable)e));
        }
    }

    protected static Optional<Integer> getMsgId(String reply) {
        Matcher matcher = MSGID_PATTERN.matcher(reply);
        if (matcher.find()) {
            Integer messageId = Integer.parseInt(matcher.group(1));
            Preconditions.checkNotNull((Object)messageId, (Object)"Error in retrieving the message id");
            return Optional.of(messageId);
        }
        if (reply.contains(HELLO)) {
            return Optional.of(0);
        }
        return Optional.empty();
    }

    @Override
    public void addDeviceEventListener(NetconfDeviceOutputEventListener listener) {
        if (!this.netconfDeviceEventListeners.contains(listener)) {
            this.netconfDeviceEventListeners.add(listener);
        }
    }

    @Override
    public void removeDeviceEventListener(NetconfDeviceOutputEventListener listener) {
        this.netconfDeviceEventListeners.remove(listener);
    }

    @Override
    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public static enum NetconfMessageState {
        NO_MATCHING_PATTERN{

            @Override
            NetconfMessageState evaluateChar(char c) {
                if (c == ']') {
                    return FIRST_BRACKET;
                }
                return this;
            }
        }
        ,
        FIRST_BRACKET{

            @Override
            NetconfMessageState evaluateChar(char c) {
                if (c == ']') {
                    return SECOND_BRACKET;
                }
                return NO_MATCHING_PATTERN;
            }
        }
        ,
        SECOND_BRACKET{

            @Override
            NetconfMessageState evaluateChar(char c) {
                if (c == '>') {
                    return FIRST_BIGGER;
                }
                return NO_MATCHING_PATTERN;
            }
        }
        ,
        FIRST_BIGGER{

            @Override
            NetconfMessageState evaluateChar(char c) {
                if (c == ']') {
                    return THIRD_BRACKET;
                }
                return NO_MATCHING_PATTERN;
            }
        }
        ,
        THIRD_BRACKET{

            @Override
            NetconfMessageState evaluateChar(char c) {
                if (c == ']') {
                    return ENDING_BIGGER;
                }
                return NO_MATCHING_PATTERN;
            }
        }
        ,
        ENDING_BIGGER{

            @Override
            NetconfMessageState evaluateChar(char c) {
                if (c == '>') {
                    return END_PATTERN;
                }
                return NO_MATCHING_PATTERN;
            }
        }
        ,
        END_PATTERN{

            @Override
            NetconfMessageState evaluateChar(char c) {
                return NO_MATCHING_PATTERN;
            }
        };


        abstract NetconfMessageState evaluateChar(char var1);
    }
}

