/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.ctl;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfDeviceOutputEvent;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.onosproject.netconf.TargetConfig;
import org.onosproject.netconf.ctl.NetconfControllerImpl;
import org.onosproject.netconf.ctl.NetconfDeviceOutputEventListenerImpl;
import org.onosproject.netconf.ctl.NetconfSessionDelegate;
import org.onosproject.netconf.ctl.NetconfStreamHandler;
import org.onosproject.netconf.ctl.NetconfStreamThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NetconfSessionImpl
implements NetconfSession {
    private static final Logger log = LoggerFactory.getLogger(NetconfSessionImpl.class);
    private static final String ENDPATTERN = "]]>]]>";
    private static final String MESSAGE_ID_STRING = "message-id";
    private static final String HELLO = "<hello";
    private static final String NEW_LINE = "\n";
    private static final String END_OF_RPC_OPEN_TAG = "\">";
    private static final String EQUAL = "=";
    private static final String NUMBER_BETWEEN_QUOTES_MATCHER = "\"+([0-9]+)+\"";
    private static final String RPC_OPEN = "<rpc ";
    private static final String RPC_CLOSE = "</rpc>";
    private static final String GET_OPEN = "<get>";
    private static final String GET_CLOSE = "</get>";
    private static final String WITH_DEFAULT_OPEN = "<with-defaults ";
    private static final String WITH_DEFAULT_CLOSE = "</with-defaults>";
    private static final String DEFAULT_OPERATION_OPEN = "<default-operation>";
    private static final String DEFAULT_OPERATION_CLOSE = "</default-operation>";
    private static final String SUBTREE_FILTER_OPEN = "<filter type=\"subtree\">";
    private static final String SUBTREE_FILTER_CLOSE = "</filter>";
    private static final String EDIT_CONFIG_OPEN = "<edit-config>";
    private static final String EDIT_CONFIG_CLOSE = "</edit-config>";
    private static final String TARGET_OPEN = "<target>";
    private static final String TARGET_CLOSE = "</target>";
    private static final String CONFIG_OPEN = "<config xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">";
    private static final String CONFIG_CLOSE = "</config>";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String NETCONF_BASE_NAMESPACE = "xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\"";
    private static final String NETCONF_WITH_DEFAULTS_NAMESPACE = "xmlns=\"urn:ietf:params:xml:ns:yang:ietf-netconf-with-defaults\"";
    private static final String SUBSCRIPTION_SUBTREE_FILTER_OPEN = "<filter xmlns:base10=\"urn:ietf:params:xml:ns:netconf:base:1.0\" base10:type=\"subtree\">";
    private static Pattern msgIdPattern = Pattern.compile("(message-id=\"[0-9]+\")");
    private final AtomicInteger messageIdInteger = new AtomicInteger(0);
    private Connection netconfConnection;
    private NetconfDeviceInfo deviceInfo;
    private Session sshSession;
    private boolean connectionActive;
    private List<String> deviceCapabilities = Collections.singletonList("urn:ietf:params:netconf:base:1.0");
    private String serverCapabilities;
    private NetconfStreamHandler streamHandler;
    private Map<Integer, CompletableFuture<String>> replies;
    private List<String> errorReplies;
    private boolean subscriptionConnected = false;
    private String notificationFilterSchema = null;

    public NetconfSessionImpl(NetconfDeviceInfo deviceInfo) throws NetconfException {
        this.deviceInfo = deviceInfo;
        this.netconfConnection = null;
        this.sshSession = null;
        this.connectionActive = false;
        this.replies = new ConcurrentHashMap<Integer, CompletableFuture<String>>();
        this.errorReplies = new ArrayList<String>();
        this.startConnection();
    }

    private void startConnection() throws NetconfException {
        if (!this.connectionActive) {
            boolean isAuthenticated;
            this.netconfConnection = new Connection(this.deviceInfo.ip().toString(), this.deviceInfo.port());
            int connectTimeout = NetconfControllerImpl.netconfConnectTimeout;
            try {
                this.netconfConnection.connect(null, 1000 * connectTimeout, 1000 * connectTimeout);
            }
            catch (IOException e) {
                throw new NetconfException("Cannot open a connection with device " + this.deviceInfo, (Throwable)e);
            }
            try {
                if (this.deviceInfo.getKeyFile() != null && this.deviceInfo.getKeyFile().canRead()) {
                    log.debug("Authenticating with key file to device {} with username {}", (Object)this.deviceInfo.getDeviceId(), (Object)this.deviceInfo.name());
                    isAuthenticated = this.netconfConnection.authenticateWithPublicKey(this.deviceInfo.name(), this.deviceInfo.getKeyFile(), this.deviceInfo.password().equals("") ? null : this.deviceInfo.password());
                } else if (this.deviceInfo.getKey() != null) {
                    log.debug("Authenticating with key to device {} with username {}", (Object)this.deviceInfo.getDeviceId(), (Object)this.deviceInfo.name());
                    isAuthenticated = this.netconfConnection.authenticateWithPublicKey(this.deviceInfo.name(), this.deviceInfo.getKey(), this.deviceInfo.password().equals("") ? null : this.deviceInfo.password());
                } else {
                    log.debug("Authenticating to device {} with username {} with password", (Object)this.deviceInfo.getDeviceId(), (Object)this.deviceInfo.name());
                    isAuthenticated = this.netconfConnection.authenticateWithPassword(this.deviceInfo.name(), this.deviceInfo.password());
                }
            }
            catch (IOException e) {
                log.error("Authentication connection to device {} failed", (Object)this.deviceInfo.getDeviceId(), (Object)e);
                throw new NetconfException("Authentication connection to device " + this.deviceInfo.getDeviceId() + " failed", (Throwable)e);
            }
            this.connectionActive = true;
            Preconditions.checkArgument((boolean)isAuthenticated, (String)"Authentication to device %s with username %s failed", (Object)this.deviceInfo.getDeviceId(), (Object)this.deviceInfo.name());
            this.startSshSession();
        }
    }

    private void startSshSession() throws NetconfException {
        try {
            this.sshSession = this.netconfConnection.openSession();
            this.sshSession.startSubSystem("netconf");
            this.streamHandler = new NetconfStreamThread(this.sshSession.getStdout(), this.sshSession.getStdin(), this.sshSession.getStderr(), this.deviceInfo, new NetconfSessionDelegateImpl(), this.replies);
            this.addDeviceOutputListener(new NetconfDeviceOutputEventListenerImpl(this.deviceInfo));
            this.sendHello();
        }
        catch (IOException e) {
            log.error("Failed to create ch.ethz.ssh2.Session session {} ", (Object)e.getMessage());
            throw new NetconfException("Failed to create ch.ethz.ssh2.Session session with device" + this.deviceInfo, (Throwable)e);
        }
    }

    @Beta
    private void startSubscriptionConnection(String filterSchema) throws NetconfException {
        if (!this.serverCapabilities.contains("interleave")) {
            throw new NetconfException("Device" + this.deviceInfo + "does not support interleave");
        }
        String reply = this.sendRequest(this.createSubscriptionString(filterSchema));
        if (!this.checkReply(reply)) {
            throw new NetconfException("Subscription not successful with device " + this.deviceInfo + " with reply " + reply);
        }
        this.subscriptionConnected = true;
    }

    public void startSubscription() throws NetconfException {
        if (!this.subscriptionConnected) {
            this.startSubscriptionConnection(null);
        }
        this.streamHandler.setEnableNotifications(true);
    }

    @Beta
    public void startSubscription(String filterSchema) throws NetconfException {
        if (!this.subscriptionConnected) {
            this.notificationFilterSchema = filterSchema;
            this.startSubscriptionConnection(filterSchema);
        }
        this.streamHandler.setEnableNotifications(true);
    }

    @Beta
    private String createSubscriptionString(String filterSchema) {
        StringBuilder subscriptionbuffer = new StringBuilder();
        subscriptionbuffer.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        subscriptionbuffer.append("  <create-subscription\n");
        subscriptionbuffer.append("xmlns=\"urn:ietf:params:xml:ns:netconf:notification:1.0\">\n");
        if (filterSchema != null) {
            subscriptionbuffer.append("    ");
            subscriptionbuffer.append(SUBSCRIPTION_SUBTREE_FILTER_OPEN).append(NEW_LINE);
            subscriptionbuffer.append(filterSchema).append(NEW_LINE);
            subscriptionbuffer.append("    ");
            subscriptionbuffer.append(SUBTREE_FILTER_CLOSE).append(NEW_LINE);
        }
        subscriptionbuffer.append("  </create-subscription>\n");
        subscriptionbuffer.append("</rpc>\n");
        subscriptionbuffer.append(ENDPATTERN);
        return subscriptionbuffer.toString();
    }

    public void endSubscription() throws NetconfException {
        if (!this.subscriptionConnected) {
            throw new NetconfException("Subscription does not exist.");
        }
        this.streamHandler.setEnableNotifications(false);
    }

    private void sendHello() throws NetconfException {
        this.serverCapabilities = this.sendRequest(this.createHelloString());
    }

    private String createHelloString() {
        StringBuilder hellobuffer = new StringBuilder();
        hellobuffer.append(XML_HEADER);
        hellobuffer.append(NEW_LINE);
        hellobuffer.append("<hello xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        hellobuffer.append("  <capabilities>\n");
        this.deviceCapabilities.forEach(cap -> hellobuffer.append("    <capability>").append((String)cap).append("</capability>\n"));
        hellobuffer.append("  </capabilities>\n");
        hellobuffer.append("</hello>\n");
        hellobuffer.append(ENDPATTERN);
        return hellobuffer.toString();
    }

    public void checkAndReestablish() throws NetconfException {
        if (this.sshSession.getState() != 2) {
            try {
                log.debug("Trying to reopen the Sesion with {}", (Object)this.deviceInfo.getDeviceId());
                this.startSshSession();
            }
            catch (IOException | IllegalStateException e) {
                log.debug("Trying to reopen the Connection with {}", (Object)this.deviceInfo.getDeviceId());
                try {
                    this.connectionActive = false;
                    this.replies.clear();
                    this.messageIdInteger.set(0);
                    this.startConnection();
                    if (this.subscriptionConnected) {
                        log.debug("Restarting subscription with {}", (Object)this.deviceInfo.getDeviceId());
                        this.subscriptionConnected = false;
                        this.startSubscription(this.notificationFilterSchema);
                    }
                }
                catch (IOException e2) {
                    log.error("No connection {} for device {}", (Object)this.netconfConnection, (Object)e.getMessage());
                    throw new NetconfException("Cannot re-open the connection with device" + this.deviceInfo, (Throwable)e);
                }
            }
        }
    }

    public String requestSync(String request) throws NetconfException {
        if (!request.contains(ENDPATTERN)) {
            request = request + NEW_LINE + ENDPATTERN;
        }
        String reply = this.sendRequest(request);
        this.checkReply(reply);
        return reply;
    }

    @Deprecated
    public CompletableFuture<String> request(String request) {
        return this.streamHandler.sendMessage(request);
    }

    private CompletableFuture<String> request(String request, int messageId) {
        return this.streamHandler.sendMessage(request, messageId);
    }

    private String sendRequest(String request) throws NetconfException {
        String rp;
        this.checkAndReestablish();
        int messageId = this.messageIdInteger.getAndIncrement();
        request = this.formatRequestMessageId(request, messageId);
        request = this.formatXmlHeader(request);
        CompletableFuture<String> futureReply = this.request(request, messageId);
        int replyTimeout = NetconfControllerImpl.netconfReplyTimeout;
        try {
            rp = futureReply.get(replyTimeout, TimeUnit.SECONDS);
            this.replies.remove(messageId);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new NetconfException("No matching reply for request " + request, (Throwable)e);
        }
        log.debug("Result {} from request {} to device {}", new Object[]{rp, request, this.deviceInfo});
        return rp.trim();
    }

    private String formatRequestMessageId(String request, int messageId) {
        if (request.contains(MESSAGE_ID_STRING)) {
            request = request.replaceFirst("message-id=\"+([0-9]+)+\"", "message-id=\"" + messageId + "\"");
        } else if (!request.contains(MESSAGE_ID_STRING) && !request.contains(HELLO)) {
            request = request.replaceFirst(END_OF_RPC_OPEN_TAG, "\" message-id=\"" + messageId + END_OF_RPC_OPEN_TAG);
        }
        return request;
    }

    private String formatXmlHeader(String request) {
        if (!request.contains(XML_HEADER)) {
            request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + request;
        }
        return request;
    }

    public String doWrappedRpc(String request) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append(request);
        rpc.append(RPC_CLOSE).append(NEW_LINE);
        rpc.append(ENDPATTERN);
        String reply = this.sendRequest(rpc.toString());
        this.checkReply(reply);
        return reply;
    }

    public String get(String request) throws NetconfException {
        return this.requestSync(request);
    }

    public String get(String filterSchema, String withDefaultsMode) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append(GET_OPEN).append(NEW_LINE);
        if (filterSchema != null) {
            rpc.append(SUBTREE_FILTER_OPEN).append(NEW_LINE);
            rpc.append(filterSchema).append(NEW_LINE);
            rpc.append(SUBTREE_FILTER_CLOSE).append(NEW_LINE);
        }
        if (withDefaultsMode != null) {
            rpc.append(WITH_DEFAULT_OPEN).append(NETCONF_WITH_DEFAULTS_NAMESPACE).append(">");
            rpc.append(withDefaultsMode).append(WITH_DEFAULT_CLOSE).append(NEW_LINE);
        }
        rpc.append(GET_CLOSE).append(NEW_LINE);
        rpc.append(RPC_CLOSE).append(NEW_LINE);
        rpc.append(ENDPATTERN);
        String reply = this.sendRequest(rpc.toString());
        this.checkReply(reply);
        return reply;
    }

    public String getConfig(TargetConfig netconfTargetConfig) throws NetconfException {
        return this.getConfig(netconfTargetConfig, null);
    }

    public String getConfig(String netconfTargetConfig) throws NetconfException {
        return this.getConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig));
    }

    public String getConfig(String netconfTargetConfig, String configurationFilterSchema) throws NetconfException {
        return this.getConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig), configurationFilterSchema);
    }

    public String getConfig(TargetConfig netconfTargetConfig, String configurationSchema) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append("xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        rpc.append("<get-config>\n");
        rpc.append("<source>\n");
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append("</source>");
        if (configurationSchema != null) {
            rpc.append("<filter type=\"subtree\">\n");
            rpc.append(configurationSchema).append(NEW_LINE);
            rpc.append("</filter>\n");
        }
        rpc.append("</get-config>\n");
        rpc.append("</rpc>\n");
        rpc.append(ENDPATTERN);
        String reply = this.sendRequest(rpc.toString());
        return this.checkReply(reply) ? reply : "ERROR " + reply;
    }

    public boolean editConfig(String newConfiguration) throws NetconfException {
        newConfiguration = newConfiguration + ENDPATTERN;
        return this.checkReply(this.sendRequest(newConfiguration));
    }

    public boolean editConfig(String netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        return this.editConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig), mode, newConfiguration);
    }

    public boolean editConfig(TargetConfig netconfTargetConfig, String mode, String newConfiguration) throws NetconfException {
        newConfiguration = newConfiguration.trim();
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(MESSAGE_ID_STRING);
        rpc.append(EQUAL);
        rpc.append("\"");
        rpc.append(this.messageIdInteger.get());
        rpc.append("\"  ");
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append(EDIT_CONFIG_OPEN).append(NEW_LINE);
        rpc.append(TARGET_OPEN);
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append(TARGET_CLOSE).append(NEW_LINE);
        if (mode != null) {
            rpc.append(DEFAULT_OPERATION_OPEN);
            rpc.append(mode);
            rpc.append(DEFAULT_OPERATION_CLOSE).append(NEW_LINE);
        }
        rpc.append(CONFIG_OPEN).append(NEW_LINE);
        rpc.append(newConfiguration);
        rpc.append(CONFIG_CLOSE).append(NEW_LINE);
        rpc.append(EDIT_CONFIG_CLOSE).append(NEW_LINE);
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        log.debug(rpc.toString());
        String reply = this.sendRequest(rpc.toString());
        return this.checkReply(reply);
    }

    public boolean copyConfig(String netconfTargetConfig, String newConfiguration) throws NetconfException {
        return this.copyConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig), newConfiguration);
    }

    public boolean copyConfig(TargetConfig netconfTargetConfig, String newConfiguration) throws NetconfException {
        if (!(newConfiguration = newConfiguration.trim()).startsWith("<config>")) {
            newConfiguration = "<config>" + newConfiguration + CONFIG_CLOSE;
        }
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append(RPC_OPEN);
        rpc.append(NETCONF_BASE_NAMESPACE).append(">\n");
        rpc.append("<copy-config>");
        rpc.append(TARGET_OPEN);
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("<source>");
        rpc.append(newConfiguration);
        rpc.append("</source>");
        rpc.append("</copy-config>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        return this.checkReply(this.sendRequest(rpc.toString()));
    }

    public boolean deleteConfig(String netconfTargetConfig) throws NetconfException {
        return this.deleteConfig(TargetConfig.toTargetConfig((String)netconfTargetConfig));
    }

    public boolean deleteConfig(TargetConfig netconfTargetConfig) throws NetconfException {
        if (netconfTargetConfig.equals((Object)TargetConfig.RUNNING)) {
            log.warn("Target configuration for delete operation can't be \"running\"", (Object)netconfTargetConfig);
            return false;
        }
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append("<rpc>");
        rpc.append("<delete-config>");
        rpc.append(TARGET_OPEN);
        rpc.append("<").append(netconfTargetConfig).append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("</delete-config>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        return this.checkReply(this.sendRequest(rpc.toString()));
    }

    public boolean lock(String configType) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        rpc.append("<lock>");
        rpc.append(TARGET_OPEN);
        rpc.append("<");
        rpc.append(configType);
        rpc.append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("</lock>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        String lockReply = this.sendRequest(rpc.toString());
        return this.checkReply(lockReply);
    }

    public boolean unlock(String configType) throws NetconfException {
        StringBuilder rpc = new StringBuilder(XML_HEADER);
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n");
        rpc.append("<unlock>");
        rpc.append(TARGET_OPEN);
        rpc.append("<");
        rpc.append(configType);
        rpc.append("/>");
        rpc.append(TARGET_CLOSE);
        rpc.append("</unlock>");
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        String unlockReply = this.sendRequest(rpc.toString());
        return this.checkReply(unlockReply);
    }

    public boolean lock() throws NetconfException {
        return this.lock("running");
    }

    public boolean unlock() throws NetconfException {
        return this.unlock("running");
    }

    public boolean close() throws NetconfException {
        return this.close(false);
    }

    private boolean close(boolean force) throws NetconfException {
        StringBuilder rpc = new StringBuilder();
        rpc.append("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        if (force) {
            rpc.append("<kill-session/>");
        } else {
            rpc.append("<close-session/>");
        }
        rpc.append(RPC_CLOSE);
        rpc.append(ENDPATTERN);
        return this.checkReply(this.sendRequest(rpc.toString())) || this.close(true);
    }

    public String getSessionId() {
        if (this.serverCapabilities.contains("<session-id>")) {
            String[] outer = this.serverCapabilities.split("<session-id>");
            Preconditions.checkArgument((outer.length != 1 ? 1 : 0) != 0, (Object)"Error in retrieving the session id");
            String[] value = outer[1].split("</session-id>");
            Preconditions.checkArgument((value.length != 1 ? 1 : 0) != 0, (Object)"Error in retrieving the session id");
            return value[0];
        }
        return String.valueOf(-1);
    }

    public String getServerCapabilities() {
        return this.serverCapabilities;
    }

    public void setDeviceCapabilities(List<String> capabilities) {
        this.deviceCapabilities = capabilities;
    }

    public void addDeviceOutputListener(NetconfDeviceOutputEventListener listener) {
        this.streamHandler.addDeviceEventListener(listener);
    }

    public void removeDeviceOutputListener(NetconfDeviceOutputEventListener listener) {
        this.streamHandler.removeDeviceEventListener(listener);
    }

    private boolean checkReply(String reply) throws NetconfException {
        if (reply != null) {
            if (!reply.contains("<rpc-error>")) {
                log.debug("Device {} sent reply {}", (Object)this.deviceInfo, (Object)reply);
                return true;
            }
            if (reply.contains("<ok/>") || reply.contains("<rpc-error>") && reply.contains("warning")) {
                log.debug("Device {} sent reply {}", (Object)this.deviceInfo, (Object)reply);
                return true;
            }
        }
        log.warn("Device {} has error in reply {}", (Object)this.deviceInfo, (Object)reply);
        return false;
    }

    public class NetconfSessionDelegateImpl
    implements NetconfSessionDelegate {
        @Override
        public void notify(NetconfDeviceOutputEvent event) {
            Optional messageId = event.getMessageID();
            log.debug("messageID {}, waiting replies messageIDs {}", (Object)messageId, NetconfSessionImpl.this.replies.keySet());
            if (!messageId.isPresent()) {
                NetconfSessionImpl.this.errorReplies.add(event.getMessagePayload());
                log.error("Device {} sent error reply {}", (Object)event.getDeviceInfo(), (Object)event.getMessagePayload());
                return;
            }
            CompletableFuture completedReply = (CompletableFuture)NetconfSessionImpl.this.replies.get(messageId.get());
            if (completedReply != null) {
                completedReply.complete(event.getMessagePayload());
            }
        }
    }
}

