/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.cli.impl;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.DeviceIdCompleter;
import org.onosproject.net.DeviceId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;

@Command(scope="onos", name="netconf-subscription-test", description="Debug command to start subscription on specified device")
public class NetconfSubscriptionTestCommand
extends AbstractShellCommand {
    DeviceIdCompleter uriCompleter;
    @Argument(index=0, name="deviceId", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Option(name="--end", description="Ends subscription instead of starting", required=false)
    boolean end = false;

    protected void execute() {
        DeviceId did;
        NetconfController controller = (NetconfController)NetconfSubscriptionTestCommand.get(NetconfController.class);
        NetconfDevice netconfDevice = controller.getNetconfDevice(did = DeviceId.deviceId((String)this.uri));
        if (netconfDevice == null) {
            this.print("%s not found or not connected to this node", new Object[]{did});
            return;
        }
        if (!this.end) {
            try {
                netconfDevice.getSession().startSubscription();
            }
            catch (NetconfException e) {
                this.log.error("Exception thrown", (Throwable)e);
                this.print("starting subscription failed (see log for details)", new Object[0]);
            }
        } else {
            try {
                netconfDevice.getSession().endSubscription();
            }
            catch (NetconfException e) {
                this.log.error("Exception thrown", (Throwable)e);
                this.print("ending subscription failed (see log for details)", new Object[0]);
            }
        }
    }
}

