/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.cli.impl;

import com.google.common.base.Preconditions;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ConfigSetter;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;

@Command(scope="onos", name="netconf-rpc-test", description="Debug tool to send NETCONF RPC request")
public class NetconfRpcTestCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    private String uri = null;
    @Argument(index=1, name="cfgFile", description="File path to RPC XML", required=true, multiValued=false)
    private String cfgFile = null;
    private DeviceId deviceId;

    protected void execute() {
        DriverService service = (DriverService)NetconfRpcTestCommand.get(DriverService.class);
        this.deviceId = DeviceId.deviceId((String)this.uri);
        DriverHandler h = service.createHandler(this.deviceId, new String[0]);
        ConfigSetter config = (ConfigSetter)h.behaviour(ConfigSetter.class);
        Preconditions.checkNotNull((Object)this.cfgFile, (Object)"Configuration file cannot be null");
        this.print(config.setConfiguration(this.cfgFile), new Object[0]);
    }
}

