/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.netconf.cli.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.netconf.DatastoreId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfSession;

@Command(scope="onos", name="netconf-get-config", description="Gets the configuration of the specified type from thespecified device.")
public class NetconfConfigGetCommand
extends AbstractShellCommand {
    @Argument(index=0, name="uri", description="Device ID", required=true, multiValued=false)
    String uri = null;
    @Argument(index=1, name="cfgType", description="Configuration datastore name (running, etc.)", required=true, multiValued=false)
    String cfgType = null;
    private DeviceId deviceId;

    protected void execute() {
        this.deviceId = DeviceId.deviceId((String)this.uri);
        NetconfController controller = (NetconfController)NetconfConfigGetCommand.get(NetconfController.class);
        Preconditions.checkNotNull((Object)controller, (Object)"Netconf controller is null");
        NetconfDevice device = (NetconfDevice)controller.getDevicesMap().get(this.deviceId);
        if (device == null) {
            this.print("Netconf device object not found for %s", new Object[]{this.deviceId});
            return;
        }
        NetconfSession session = device.getSession();
        if (session == null) {
            this.print("Netconf session not found for %s", new Object[]{this.deviceId});
            return;
        }
        try {
            String res = session.getConfig(DatastoreId.datastore((String)this.cfgType.toLowerCase()));
            this.print("%s", new Object[]{res});
        }
        catch (IOException e) {
            this.log.error("Configuration could not be retrieved", (Throwable)e);
            this.print("Error occured retrieving configuration", new Object[0]);
        }
    }
}

