/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknode.OpenstackNode;
import org.onosproject.openstacknode.OpenstackNodeService;

@Command(scope="onos", name="openstack-nodes", description="Lists all nodes registered in OpenStack node service")
public class OpenstackNodeListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "%-20s%-15s%-24s%-24s%-20s%-20s%-15s%s";

    protected void execute() {
        OpenstackNodeService nodeService = (OpenstackNodeService)AbstractShellCommand.get(OpenstackNodeService.class);
        List<OpenstackNode> nodes = nodeService.nodes();
        nodes.sort(OpenstackNode.OPENSTACK_NODE_COMPARATOR);
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.json(nodes)});
        } else {
            this.print(FORMAT, new Object[]{"Hostname", "Type", "Integration Bridge", "Router Bridge", "Management IP", "Data IP", "VLAN Intf", "State"});
            for (OpenstackNode node : nodes) {
                this.print(FORMAT, new Object[]{node.hostname(), node.type(), node.intBridge(), node.routerBridge().isPresent() ? node.routerBridge().get() : "", node.managementIp(), node.dataIp().isPresent() ? node.dataIp().get() : "", node.vlanPort().isPresent() ? node.vlanPort().get() : "", node.state()});
            }
            this.print("Total %s nodes", new Object[]{nodeService.nodes().size()});
        }
    }

    private JsonNode json(List<OpenstackNode> nodes) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (OpenstackNode node : nodes) {
            result.add((JsonNode)mapper.createObjectNode().put("hostname", node.hostname()).put("type", node.type().name()).put("intBridge", node.intBridge().toString()).put("routerBridge", node.routerBridge().toString()).put("managementIp", node.managementIp().toString()).put("dataIp", node.dataIp().toString()).put("vlanPort", node.vlanPort().toString()).put("state", node.state().name()));
        }
        return result;
    }
}

