/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode.cli;

import java.util.NoSuchElementException;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.openstacknode.OpenstackNode;
import org.onosproject.openstacknode.OpenstackNodeService;

@Command(scope="onos", name="openstack-node-init", description="Initializes nodes for OpenStack node service")
public class OpenstackNodeInitCommand
extends AbstractShellCommand {
    @Argument(index=0, name="hostnames", description="Hostname(s)", required=true, multiValued=true)
    private String[] hostnames = null;

    protected void execute() {
        OpenstackNodeService nodeService = (OpenstackNodeService)AbstractShellCommand.get(OpenstackNodeService.class);
        for (String hostname : this.hostnames) {
            OpenstackNode node;
            try {
                node = nodeService.nodes().stream().filter(n -> n.hostname().equals(hostname)).findFirst().get();
            }
            catch (NoSuchElementException e) {
                this.print("Unable to find %s", new Object[]{hostname});
                continue;
            }
            nodeService.addOrUpdateNode(node);
        }
    }
}

