/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode.cli;

import java.util.Optional;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.openstacknode.OpenstackNode;
import org.onosproject.openstacknode.OpenstackNodeService;

@Command(scope="onos", name="openstack-node-check", description="Shows detailed node init state")
public class OpenstackNodeCheckCommand
extends AbstractShellCommand {
    @Argument(index=0, name="hostname", description="Hostname", required=true, multiValued=false)
    private String hostname = null;
    private static final String MSG_OK = "OK";
    private static final String MSG_NO = "NO";

    protected void execute() {
        OpenstackNodeService nodeService = (OpenstackNodeService)AbstractShellCommand.get(OpenstackNodeService.class);
        DeviceService deviceService = (DeviceService)AbstractShellCommand.get(DeviceService.class);
        OpenstackNode node = nodeService.nodes().stream().filter(n -> n.hostname().equals(this.hostname)).findFirst().orElse(null);
        if (node == null) {
            this.print("Cannot find %s from registered nodes", new Object[]{this.hostname});
            return;
        }
        this.print("[Integration Bridge Status]", new Object[0]);
        Device device = deviceService.getDevice(node.intBridge());
        if (device != null) {
            this.print("%s %s=%s available=%s %s", new Object[]{deviceService.isAvailable(device.id()) ? MSG_OK : MSG_NO, "br-int", device.id(), deviceService.isAvailable(device.id()), device.annotations()});
            node.dataIp().ifPresent(ip -> this.print(this.getPortState(deviceService, node.intBridge(), "vxlan"), new Object[0]));
            node.vlanPort().ifPresent(p -> this.print(this.getPortState(deviceService, node.intBridge(), (String)p), new Object[0]));
        } else {
            this.print("%s %s=%s is not available", new Object[]{MSG_NO, "br-int", node.intBridge()});
        }
        if (node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)) {
            this.print(this.getPortState(deviceService, node.intBridge(), "patch-intg"), new Object[0]);
            this.print("%n[Router Bridge Status]", new Object[0]);
            device = deviceService.getDevice(node.ovsdbId());
            if (device == null || !device.is(BridgeConfig.class)) {
                this.print("%s %s=%s is not available(unable to connect OVSDB)", new Object[]{MSG_NO, "br-router", node.intBridge()});
            } else {
                BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
                boolean available = bridgeConfig.getBridges().stream().filter(bridge -> bridge.name().equals("br-router")).findAny().isPresent();
                this.print("%s %s=%s available=%s", new Object[]{available ? MSG_OK : MSG_NO, "br-router", node.routerBridge().get(), available});
                this.print(this.getPortStateOvsdb(deviceService, node.ovsdbId(), "patch-rout"), new Object[0]);
                this.print(this.getPortStateOvsdb(deviceService, node.ovsdbId(), node.uplink().get()), new Object[0]);
            }
        }
    }

    private String getPortState(DeviceService deviceService, DeviceId deviceId, String portName) {
        Port port = deviceService.getPorts(deviceId).stream().filter(p -> p.annotations().value("portName").equals(portName) && p.isEnabled()).findAny().orElse(null);
        if (port != null) {
            return String.format("%s %s portNum=%s enabled=%s %s", port.isEnabled() ? MSG_OK : MSG_NO, portName, port.number(), port.isEnabled() ? Boolean.TRUE : Boolean.FALSE, port.annotations());
        }
        return String.format("%s %s does not exist", MSG_NO, portName);
    }

    private String getPortStateOvsdb(DeviceService deviceService, DeviceId deviceId, String portName) {
        Device device = deviceService.getDevice(deviceId);
        if (device == null || !device.is(BridgeConfig.class)) {
            return String.format("%s %s does not exist(unable to connect OVSDB)", MSG_NO, portName);
        }
        BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
        Optional<PortDescription> port = bridgeConfig.getPorts().stream().filter(p -> p.annotations().value("portName").contains(portName)).findAny();
        if (port.isPresent()) {
            return String.format("%s %s portNum=%s enabled=%s %s", port.get().isEnabled() ? MSG_OK : MSG_NO, portName, port.get().portNumber(), port.get().isEnabled() ? Boolean.TRUE : Boolean.FALSE, port.get().annotations());
        }
        return String.format("%s %s does not exist", MSG_NO, portName);
    }
}

