/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionPropertyException;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.openstacknode.OpenstackNode;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectGroupHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TUNNEL_DESTINATION = "tunnelDst";
    private static final String ERR_UNSUPPORTED_NET_TYPE = "Unsupported network type";
    private final GroupService groupService;
    private final DeviceService deviceService;
    private final DriverService driverService;
    private final ApplicationId appId;

    public SelectGroupHandler(GroupService targetGroupService, DeviceService targetDeviceService, DriverService targetDriverService, ApplicationId appId) {
        this.groupService = targetGroupService;
        this.deviceService = targetDeviceService;
        this.driverService = targetDriverService;
        this.appId = appId;
    }

    public void createGatewayGroup(OpenstackNode computeNode, List<OpenstackNode> gatewayNodeList) {
        DefaultGroupDescription groupDescription;
        GroupId groupId;
        List<GroupBucket> bucketList;
        if (computeNode.dataIp().isPresent()) {
            bucketList = this.generateBucketsForSelectGroup(computeNode, gatewayNodeList, OpenstackNodeService.NetworkMode.VXLAN);
            groupId = this.groupId(computeNode.intBridge(), OpenstackNodeService.NetworkMode.VXLAN);
            groupDescription = new DefaultGroupDescription(computeNode.intBridge(), GroupDescription.Type.SELECT, new GroupBuckets(bucketList), this.groupKey(computeNode.intBridge(), OpenstackNodeService.NetworkMode.VXLAN), (Integer)groupId.id(), this.appId);
            this.groupService.addGroup((GroupDescription)groupDescription);
        }
        if (computeNode.vlanPort().isPresent()) {
            bucketList = this.generateBucketsForSelectGroup(computeNode, gatewayNodeList, OpenstackNodeService.NetworkMode.VLAN);
            groupId = this.groupId(computeNode.intBridge(), OpenstackNodeService.NetworkMode.VLAN);
            groupDescription = new DefaultGroupDescription(computeNode.intBridge(), GroupDescription.Type.SELECT, new GroupBuckets(bucketList), this.groupKey(computeNode.intBridge(), OpenstackNodeService.NetworkMode.VLAN), (Integer)groupId.id(), this.appId);
            this.groupService.addGroup((GroupDescription)groupDescription);
        }
    }

    public GroupKey groupKey(DeviceId srcDeviceId, OpenstackNodeService.NetworkMode networkMode) {
        if (networkMode.equals((Object)OpenstackNodeService.NetworkMode.VXLAN)) {
            return new DefaultGroupKey(srcDeviceId.toString().concat("vxlan").getBytes());
        }
        return new DefaultGroupKey(srcDeviceId.toString().concat("vlan").getBytes());
    }

    private GroupId groupId(DeviceId srcDeviceId, OpenstackNodeService.NetworkMode networkMode) {
        if (networkMode.equals((Object)OpenstackNodeService.NetworkMode.VXLAN)) {
            return new GroupId(srcDeviceId.toString().concat("vxlan").hashCode());
        }
        return new GroupId(srcDeviceId.toString().concat("vlan").hashCode());
    }

    public void updateGatewayGroupBuckets(OpenstackNode computeNode, List<OpenstackNode> gatewayNodeList, OpenstackNodeService.NetworkMode networkMode, boolean isInsert) {
        List<GroupBucket> bucketList = this.generateBucketsForSelectGroup(computeNode, gatewayNodeList, networkMode);
        GroupKey groupKey = this.groupKey(computeNode.intBridge(), networkMode);
        if (this.groupService.getGroup(computeNode.intBridge(), groupKey) == null) {
            this.log.error("There's no group in compute node {}", (Object)computeNode.intBridge());
            return;
        }
        if (isInsert) {
            this.groupService.addBucketsToGroup(computeNode.intBridge(), groupKey, new GroupBuckets(bucketList), groupKey, this.appId);
        } else {
            this.groupService.removeBucketsFromGroup(computeNode.intBridge(), groupKey, new GroupBuckets(bucketList), groupKey, this.appId);
        }
    }

    private List<GroupBucket> generateBucketsForSelectGroup(OpenstackNode computeNode, List<OpenstackNode> gatewayNodeList, OpenstackNodeService.NetworkMode networkMode) {
        ArrayList bucketList = Lists.newArrayList();
        switch (networkMode) {
            case VXLAN: {
                gatewayNodeList.stream().filter(node -> node.dataIp().isPresent()).forEach(node -> {
                    TrafficTreatment tBuilder = DefaultTrafficTreatment.builder().extension(this.buildNiciraExtenstion(computeNode.intBridge(), node.dataIp().get().getIp4Address()), computeNode.intBridge()).setOutput(this.getTunnelPort(computeNode.intBridge())).build();
                    bucketList.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)tBuilder));
                });
                return bucketList;
            }
            case VLAN: {
                gatewayNodeList.stream().filter(node -> node.vlanPort().isPresent()).forEach(node -> {
                    TrafficTreatment tBuilder = DefaultTrafficTreatment.builder().setEthDst(MacAddress.valueOf((String)this.vlanPortMac((OpenstackNode)node))).setOutput(this.vlanPortNum(computeNode)).build();
                    bucketList.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)tBuilder));
                });
                return bucketList;
            }
        }
        String error = String.format("Unsupported network type%s", networkMode.toString());
        throw new IllegalStateException(error);
    }

    private ExtensionTreatment buildNiciraExtenstion(DeviceId id, Ip4Address hostIp) {
        Driver driver = this.driverService.getDriver(id);
        DefaultDriverHandler driverHandler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, id));
        ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)driverHandler.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment extensionInstruction = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
        try {
            extensionInstruction.setPropertyValue(TUNNEL_DESTINATION, (Object)hostIp);
        }
        catch (ExtensionPropertyException e) {
            this.log.error("Error setting Nicira extension setting {}", (Throwable)e);
        }
        return extensionInstruction;
    }

    private PortNumber getTunnelPort(DeviceId deviceId) {
        Port port = this.deviceService.getPorts(deviceId).stream().filter(p -> p.annotations().value("portName").equals("vxlan")).findAny().orElse(null);
        if (port == null) {
            this.log.error("No TunnelPort was created.");
            return null;
        }
        return port.number();
    }

    private PortNumber vlanPortNum(OpenstackNode node) {
        return this.deviceService.getPorts(node.intBridge()).stream().filter(p -> p.annotations().value("portName").equals(node.vlanPort().get()) && p.isEnabled()).map(Port::number).findFirst().get();
    }

    private String vlanPortMac(OpenstackNode node) {
        return this.deviceService.getPorts(node.intBridge()).stream().filter(p -> p.annotations().value("portName").equals(node.vlanPort().get()) && p.isEnabled()).findFirst().get().annotations().value("portMac");
    }
}

