/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.BridgeName;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.behaviour.DefaultBridgeDescription;
import org.onosproject.net.behaviour.DefaultPatchDescription;
import org.onosproject.net.behaviour.DefaultTunnelDescription;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.behaviour.PatchDescription;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.behaviour.TunnelEndPoints;
import org.onosproject.net.behaviour.TunnelKeys;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.openstacknode.ConnectionHandler;
import org.onosproject.openstacknode.OpenstackNode;
import org.onosproject.openstacknode.OpenstackNodeConfig;
import org.onosproject.openstacknode.OpenstackNodeEvent;
import org.onosproject.openstacknode.OpenstackNodeListener;
import org.onosproject.openstacknode.OpenstackNodeService;
import org.onosproject.openstacknode.SelectGroupHandler;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public final class OpenstackNodeManager
extends ListenerRegistry<OpenstackNodeEvent, OpenstackNodeListener>
implements OpenstackNodeService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final KryoNamespace.Builder NODE_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{OpenstackNode.class}).register(new Class[]{OpenstackNodeService.NodeType.class}).register(new Class[]{OpenstackNodeEvent.NodeState.class});
    private static final String OVSDB_PORT = "ovsdbPort";
    private static final int DPID_BEGIN = 3;
    private static final String APP_ID = "org.onosproject.openstacknode";
    private static final Class<OpenstackNodeConfig> CONFIG_CLASS = OpenstackNodeConfig.class;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OvsdbController ovsdbController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry configRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Property(name="ovsdbPort", intValue={6640}, label="OVSDB server listen port")
    private int ovsdbPort = 6640;
    private final ExecutorService eventExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/openstack-node", (String)"event-handler", (Logger)this.log));
    private final ConfigFactory configFactory = new ConfigFactory<ApplicationId, OpenstackNodeConfig>(SubjectFactories.APP_SUBJECT_FACTORY, CONFIG_CLASS, "openstacknode"){

        public OpenstackNodeConfig createConfig() {
            return new OpenstackNodeConfig();
        }
    };
    private final NetworkConfigListener configListener = new InternalConfigListener();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private final MapEventListener<String, OpenstackNode> nodeStoreListener = new InternalMapListener();
    private final OvsdbHandler ovsdbHandler = new OvsdbHandler();
    private final BridgeHandler bridgeHandler = new BridgeHandler();
    private ConsistentMap<String, OpenstackNode> nodeStore;
    private SelectGroupHandler selectGroupHandler;
    private ApplicationId appId;
    private NodeId localNodeId;

    @Activate
    protected void activate() {
        this.appId = this.coreService.getAppId(APP_ID);
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.runForLeadership(this.appId.name());
        this.nodeStore = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)NODE_SERIALIZER.build()))).withName("openstack-nodestore")).withApplicationId(this.appId)).build();
        this.nodeStore.addListener(this.nodeStoreListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.configRegistry.registerConfigFactory(this.configFactory);
        this.configRegistry.addListener((EventListener)this.configListener);
        this.componentConfigService.registerProperties(this.getClass());
        this.selectGroupHandler = new SelectGroupHandler(this.groupService, this.deviceService, this.driverService, this.appId);
        this.readConfiguration();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.configRegistry.removeListener((EventListener)this.configListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.nodeStore.removeListener(this.nodeStoreListener);
        this.componentConfigService.unregisterProperties(this.getClass(), false);
        this.configRegistry.unregisterConfigFactory(this.configFactory);
        this.leadershipService.withdraw(this.appId.name());
        this.eventExecutor.shutdown();
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        int updatedOvsdbPort = Tools.getIntegerProperty((Dictionary)properties, (String)OVSDB_PORT);
        if (!Objects.equals(updatedOvsdbPort, this.ovsdbPort)) {
            this.ovsdbPort = updatedOvsdbPort;
        }
        this.log.info("Modified");
    }

    @Override
    public void addOrUpdateNode(OpenstackNode node) {
        this.nodeStore.computeIf((Object)node.hostname(), v -> v == null || !v.equals(node) || v.state() != OpenstackNodeEvent.NodeState.COMPLETE, (k, v) -> OpenstackNode.getUpdatedNode(node, this.nodeState(node)));
    }

    @Override
    public void deleteNode(OpenstackNode node) {
        this.nodeStore.remove((Object)node.hostname());
        this.process((Event)new OpenstackNodeEvent(OpenstackNodeEvent.NodeState.INCOMPLETE, node));
    }

    @Override
    public void processInitState(OpenstackNode node) {
        if (!this.isOvsdbConnected(node)) {
            this.connectOvsdb(node);
            return;
        }
        this.process((Event)new OpenstackNodeEvent(OpenstackNodeEvent.NodeState.INIT, node));
        this.createBridge(node, "br-int", node.intBridge());
        if (node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)) {
            this.createBridge(node, "br-router", node.routerBridge().get());
            this.setNodeState(node, this.nodeState(node));
        }
    }

    @Override
    public void processDeviceCreatedState(OpenstackNode node) {
        if (!this.isOvsdbConnected(node)) {
            this.connectOvsdb(node);
            return;
        }
        this.process((Event)new OpenstackNodeEvent(OpenstackNodeEvent.NodeState.DEVICE_CREATED, node));
        if (node.dataIp().isPresent()) {
            this.createTunnelInterface(node);
        }
        if (node.vlanPort().isPresent()) {
            this.addVlanPort(node);
        }
        if (node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)) {
            this.createPatchInterface(node);
            this.addUplink(node);
            this.setNodeState(node, this.nodeState(node));
        }
    }

    @Override
    public void processCompleteState(OpenstackNode node) {
        this.process((Event)new OpenstackNodeEvent(OpenstackNodeEvent.NodeState.COMPLETE, node));
        switch (node.type()) {
            case COMPUTE: {
                this.selectGroupHandler.createGatewayGroup(node, this.gatewayNodes());
                break;
            }
            case GATEWAY: {
                this.updateGatewayGroup(node, true);
                break;
            }
        }
        this.log.info("Finished init {}", (Object)node.hostname());
    }

    @Override
    public void processIncompleteState(OpenstackNode node) {
        this.process((Event)new OpenstackNodeEvent(OpenstackNodeEvent.NodeState.INCOMPLETE, node));
        if (node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)) {
            this.updateGatewayGroup(node, false);
        }
    }

    @Override
    public List<OpenstackNode> nodes() {
        return this.nodeStore.values().stream().map(Versioned::value).collect(Collectors.toList());
    }

    @Override
    public Set<OpenstackNode> completeNodes() {
        return this.nodeStore.values().stream().map(Versioned::value).filter(node -> node.state().equals((Object)OpenstackNodeEvent.NodeState.COMPLETE)).collect(Collectors.toSet());
    }

    @Override
    public Optional<IpAddress> dataIp(DeviceId deviceId) {
        OpenstackNode node = this.nodeByDeviceId(deviceId);
        if (node == null) {
            this.log.warn("Failed to get node for {}", (Object)deviceId);
            return Optional.empty();
        }
        return node.dataIp();
    }

    @Override
    public Optional<PortNumber> tunnelPort(DeviceId deviceId) {
        return this.deviceService.getPorts(deviceId).stream().filter(p -> p.annotations().value("portName").equals("vxlan") && p.isEnabled()).map(Port::number).findFirst();
    }

    @Override
    public Optional<PortNumber> vlanPort(DeviceId intBridgeId) {
        Optional<String> vlanPortName = this.nodeByDeviceId(intBridgeId).vlanPort();
        return this.deviceService.getPorts(intBridgeId).stream().filter(p -> p.annotations().value("portName").equals(vlanPortName.get()) && p.isEnabled()).map(Port::number).findFirst();
    }

    @Override
    public Optional<DeviceId> routerBridge(DeviceId intBridgeId) {
        OpenstackNode node = this.nodeByDeviceId(intBridgeId);
        if (node == null || node.type().equals((Object)OpenstackNodeService.NodeType.COMPUTE)) {
            this.log.warn("Failed to find router bridge connected to {}", (Object)intBridgeId);
            return Optional.empty();
        }
        return node.routerBridge();
    }

    @Override
    public Optional<PortNumber> externalPort(DeviceId intBridgeId) {
        return this.deviceService.getPorts(intBridgeId).stream().filter(p -> p.annotations().value("portName").equals("patch-intg") && p.isEnabled()).map(Port::number).findFirst();
    }

    @Override
    public OpenstackNode gatewayNode(DeviceId deviceId) {
        OpenstackNode gatewayNode = this.nodeByDeviceId(deviceId);
        if (gatewayNode == null) {
            this.log.warn("Gateway with device ID {} does not exist");
            return null;
        }
        return gatewayNode;
    }

    @Override
    public synchronized GroupId gatewayGroupId(DeviceId srcDeviceId, OpenstackNodeService.NetworkMode networkMode) {
        GroupKey groupKey = this.selectGroupHandler.groupKey(srcDeviceId, networkMode);
        Group group = this.groupService.getGroup(srcDeviceId, groupKey);
        if (group == null) {
            this.log.info("Created gateway group for {}", (Object)srcDeviceId);
            this.selectGroupHandler.createGatewayGroup(this.nodeByDeviceId(srcDeviceId), this.gatewayNodes());
            return this.groupService.getGroup(srcDeviceId, this.selectGroupHandler.groupKey(srcDeviceId, networkMode)).id();
        }
        return group.id();
    }

    @Override
    public List<OpenstackNode> gatewayNodes() {
        return this.nodeStore.values().stream().map(Versioned::value).filter(node -> node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)).filter(node -> node.state().equals((Object)OpenstackNodeEvent.NodeState.COMPLETE)).collect(Collectors.toList());
    }

    @Override
    public List<DeviceId> gatewayDeviceIds() {
        ArrayList deviceIdList = Lists.newArrayList();
        this.nodeStore.values().stream().map(Versioned::value).filter(node -> node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)).filter(node -> node.state().equals((Object)OpenstackNodeEvent.NodeState.COMPLETE)).forEach(node -> deviceIdList.add(node.intBridge()));
        return deviceIdList;
    }

    private void updateGatewayGroup(OpenstackNode gatewayNode, boolean isInsert) {
        this.nodeStore.values().stream().map(Versioned::value).filter(node -> node.type().equals((Object)OpenstackNodeService.NodeType.COMPUTE)).filter(node -> node.dataIp().isPresent()).filter(node -> node.state().equals((Object)OpenstackNodeEvent.NodeState.COMPLETE)).forEach(computeNode -> {
            this.selectGroupHandler.updateGatewayGroupBuckets((OpenstackNode)computeNode, (List<OpenstackNode>)ImmutableList.of((Object)gatewayNode), OpenstackNodeService.NetworkMode.VXLAN, isInsert);
            this.log.trace("Updated gateway group on {} for vxlan mode", (Object)computeNode.intBridge());
        });
        this.nodeStore.values().stream().map(Versioned::value).filter(node -> node.type().equals((Object)OpenstackNodeService.NodeType.COMPUTE)).filter(node -> node.vlanPort().isPresent()).filter(node -> node.state().equals((Object)OpenstackNodeEvent.NodeState.COMPLETE)).forEach(computeNode -> {
            this.selectGroupHandler.updateGatewayGroupBuckets((OpenstackNode)computeNode, (List<OpenstackNode>)ImmutableList.of((Object)gatewayNode), OpenstackNodeService.NetworkMode.VLAN, isInsert);
            this.log.trace("Updated gateway group on {} for vlan mode", (Object)computeNode.intBridge());
        });
    }

    private void initNode(OpenstackNode node) {
        OpenstackNodeEvent.NodeState state = node.state();
        state.process(this, node);
        this.log.debug("Processing node: {} state: {}", (Object)node.hostname(), (Object)state);
    }

    private void setNodeState(OpenstackNode node, OpenstackNodeEvent.NodeState newState) {
        this.nodeStore.put((Object)node.hostname(), (Object)OpenstackNode.getUpdatedNode(node, newState));
    }

    private OpenstackNodeEvent.NodeState nodeState(OpenstackNode node) {
        if (!(this.isOvsdbConnected(node) && this.deviceService.isAvailable(node.intBridge()) && this.isBridgeCreated(node.ovsdbId(), "br-int"))) {
            return OpenstackNodeEvent.NodeState.INIT;
        }
        if (node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY) && !this.isBridgeCreated(node.ovsdbId(), "br-router")) {
            return OpenstackNodeEvent.NodeState.INIT;
        }
        if (node.dataIp().isPresent() && !this.isIfaceCreated(node.ovsdbId(), "vxlan")) {
            return OpenstackNodeEvent.NodeState.DEVICE_CREATED;
        }
        if (node.vlanPort().isPresent() && !this.isIfaceCreated(node.ovsdbId(), node.vlanPort().get())) {
            return OpenstackNodeEvent.NodeState.DEVICE_CREATED;
        }
        if (!(!node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY) || this.isIfaceCreated(node.ovsdbId(), "patch-rout") && this.isIfaceCreated(node.ovsdbId(), "patch-intg") && this.isIfaceCreated(node.ovsdbId(), node.uplink().get()))) {
            return OpenstackNodeEvent.NodeState.DEVICE_CREATED;
        }
        return OpenstackNodeEvent.NodeState.COMPLETE;
    }

    private boolean isIfaceCreated(DeviceId deviceId, String ifaceName) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null || !device.is(BridgeConfig.class)) {
            return false;
        }
        BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
        return bridgeConfig.getPorts().stream().anyMatch(port -> port.annotations().value("portName").equals(ifaceName));
    }

    private boolean isBridgeCreated(DeviceId deviceId, String bridgeName) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null || !device.is(BridgeConfig.class)) {
            return false;
        }
        BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
        return bridgeConfig.getBridges().stream().anyMatch(bridge -> bridge.name().equals(bridgeName));
    }

    private void createBridge(OpenstackNode node, String bridgeName, DeviceId deviceId) {
        Device device = this.deviceService.getDevice(node.ovsdbId());
        if (device == null || !device.is(BridgeConfig.class)) {
            this.log.error("Failed to create integration bridge on {}", (Object)node.ovsdbId());
            return;
        }
        HashSet controllerIps = bridgeName.equals("br-router") ? Sets.newHashSet((Object[])new IpAddress[]{node.routerController().get()}) : this.clusterService.getNodes().stream().map(ControllerNode::ip).collect(Collectors.toSet());
        List controllers = controllerIps.stream().map(ip -> new ControllerInfo(ip, 6653, "tcp")).collect(Collectors.toList());
        String dpid = deviceId.toString().substring(3);
        BridgeDescription bridgeDesc = DefaultBridgeDescription.builder().name(bridgeName).failMode(BridgeDescription.FailMode.SECURE).datapathId(dpid).disableInBand().controllers(controllers).build();
        BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
        bridgeConfig.addBridge(bridgeDesc);
    }

    private void createTunnelInterface(OpenstackNode node) {
        if (this.isIfaceCreated(node.ovsdbId(), "vxlan")) {
            return;
        }
        Device device = this.deviceService.getDevice(node.ovsdbId());
        if (device == null || !device.is(InterfaceConfig.class)) {
            this.log.error("Failed to create tunnel interface on {}", (Object)node.ovsdbId());
            return;
        }
        TunnelDescription tunnelDesc = DefaultTunnelDescription.builder().deviceId("br-int").ifaceName("vxlan").type(TunnelDescription.Type.VXLAN).remote(TunnelEndPoints.flowTunnelEndpoint()).key(TunnelKeys.flowTunnelKey()).build();
        InterfaceConfig ifaceConfig = (InterfaceConfig)device.as(InterfaceConfig.class);
        ifaceConfig.addTunnelMode("vxlan", tunnelDesc);
    }

    private void createPatchInterface(OpenstackNode node) {
        Preconditions.checkArgument((boolean)node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY));
        if (this.isIfaceCreated(node.ovsdbId(), "patch-intg") && this.isIfaceCreated(node.ovsdbId(), "patch-rout")) {
            return;
        }
        Device device = this.deviceService.getDevice(node.ovsdbId());
        if (device == null || !device.is(InterfaceConfig.class)) {
            this.log.error("Failed to create patch interfaces on {}", (Object)node.hostname());
            return;
        }
        PatchDescription patchIntg = DefaultPatchDescription.builder().deviceId("br-int").ifaceName("patch-intg").peer("patch-rout").build();
        PatchDescription patchRout = DefaultPatchDescription.builder().deviceId("br-router").ifaceName("patch-rout").peer("patch-intg").build();
        InterfaceConfig ifaceConfig = (InterfaceConfig)device.as(InterfaceConfig.class);
        ifaceConfig.addPatchMode("patch-intg", patchIntg);
        ifaceConfig.addPatchMode("patch-rout", patchRout);
    }

    private void addUplink(OpenstackNode node) {
        Preconditions.checkArgument((boolean)node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY));
        if (this.isIfaceCreated(node.ovsdbId(), node.uplink().get())) {
            return;
        }
        Device device = this.deviceService.getDevice(node.ovsdbId());
        if (device == null || !device.is(BridgeConfig.class)) {
            this.log.error("Failed to add port {} on {}", (Object)node.uplink().get(), (Object)node.ovsdbId());
            return;
        }
        BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
        bridgeConfig.addPort(BridgeName.bridgeName((String)"br-router"), node.uplink().get());
    }

    private void addVlanPort(OpenstackNode node) {
        if (this.isIfaceCreated(node.ovsdbId(), node.vlanPort().get())) {
            return;
        }
        Device device = this.deviceService.getDevice(node.ovsdbId());
        if (device == null || !device.is(BridgeConfig.class)) {
            this.log.error("Failed to add port {} on {}", (Object)node.vlanPort().get(), (Object)node.ovsdbId());
            return;
        }
        BridgeConfig bridgeConfig = (BridgeConfig)device.as(BridgeConfig.class);
        bridgeConfig.addPort(BridgeName.bridgeName((String)"br-int"), node.vlanPort().get());
    }

    private boolean isOvsdbConnected(OpenstackNode node) {
        OvsdbNodeId ovsdb = new OvsdbNodeId(node.managementIp(), (long)this.ovsdbPort);
        OvsdbClientService client = this.ovsdbController.getOvsdbClient(ovsdb);
        return this.deviceService.isAvailable(node.ovsdbId()) && client != null && client.isConnected();
    }

    private void connectOvsdb(OpenstackNode node) {
        this.ovsdbController.connect(node.managementIp(), TpPort.tpPort((int)this.ovsdbPort));
    }

    private Set<String> systemIfaces(OpenstackNode node) {
        HashSet ifaces = Sets.newHashSet();
        node.dataIp().ifPresent(ip -> ifaces.add("vxlan"));
        node.vlanPort().ifPresent(ifaces::add);
        if (node.type().equals((Object)OpenstackNodeService.NodeType.GATEWAY)) {
            ifaces.add("patch-intg");
            ifaces.add("patch-rout");
            ifaces.add(node.uplink().get());
        }
        return ifaces;
    }

    private OpenstackNode nodeByDeviceId(DeviceId deviceId) {
        OpenstackNode node = this.nodes().stream().filter(n -> n.intBridge().equals((Object)deviceId)).findFirst().orElseGet(() -> this.nodes().stream().filter(n -> n.routerBridge().isPresent()).filter(n -> n.routerBridge().get().equals((Object)deviceId)).findFirst().orElseGet(() -> this.nodes().stream().filter(n -> n.ovsdbId().equals((Object)deviceId)).findFirst().orElse(null)));
        return node;
    }

    private void readConfiguration() {
        OpenstackNodeConfig config = (OpenstackNodeConfig)this.configRegistry.getConfig((Object)this.appId, CONFIG_CLASS);
        if (config == null) {
            this.log.debug("No configuration found");
            return;
        }
        HashMap prevNodeMap = Maps.newHashMap((Map)this.nodeStore.asJavaMap());
        config.openstackNodes().forEach(node -> {
            prevNodeMap.remove(node.hostname());
            this.addOrUpdateNode((OpenstackNode)node);
        });
        prevNodeMap.values().forEach(this::deleteNode);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindOvsdbController(OvsdbController ovsdbController) {
        this.ovsdbController = ovsdbController;
    }

    protected void unbindOvsdbController(OvsdbController ovsdbController) {
        if (this.ovsdbController == ovsdbController) {
            this.ovsdbController = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.configRegistry = networkConfigRegistry;
    }

    protected void unbindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.configRegistry == networkConfigRegistry) {
            this.configRegistry = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    private class InternalMapListener
    implements MapEventListener<String, OpenstackNode> {
        private InternalMapListener() {
        }

        public void event(MapEvent<String, OpenstackNode> event) {
            NodeId leaderNodeId = OpenstackNodeManager.this.leadershipService.getLeader(OpenstackNodeManager.this.appId.name());
            if (!Objects.equals(OpenstackNodeManager.this.localNodeId, leaderNodeId)) {
                return;
            }
            switch (event.type()) {
                case UPDATE: {
                    OpenstackNode oldNode = (OpenstackNode)event.oldValue().value();
                    OpenstackNode newNode = (OpenstackNode)event.newValue().value();
                    OpenstackNodeManager.this.log.info("Reloaded {}", (Object)newNode.hostname());
                    if (!newNode.equals(oldNode)) {
                        OpenstackNodeManager.this.log.debug("New node: {}", (Object)newNode);
                    }
                    OpenstackNodeManager.this.eventExecutor.execute(() -> OpenstackNodeManager.this.initNode(newNode));
                    break;
                }
                case INSERT: {
                    OpenstackNode newNode = (OpenstackNode)event.newValue().value();
                    OpenstackNodeManager.this.log.info("Added {}", (Object)newNode.hostname());
                    OpenstackNodeManager.this.eventExecutor.execute(() -> OpenstackNodeManager.this.initNode(newNode));
                    break;
                }
                case REMOVE: {
                    OpenstackNode oldNode = (OpenstackNode)event.oldValue().value();
                    OpenstackNodeManager.this.log.info("Removed {}", (Object)oldNode.hostname());
                    break;
                }
            }
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            NodeId leaderNodeId = OpenstackNodeManager.this.leadershipService.getLeader(OpenstackNodeManager.this.appId.name());
            if (!Objects.equals(OpenstackNodeManager.this.localNodeId, leaderNodeId)) {
                return;
            }
            if (!event.configClass().equals(CONFIG_CLASS)) {
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: {
                    OpenstackNodeManager.this.eventExecutor.execute(() -> OpenstackNodeManager.this.readConfiguration());
                    break;
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            NodeId leaderNodeId = OpenstackNodeManager.this.leadershipService.getLeader(OpenstackNodeManager.this.appId.name());
            if (!Objects.equals(OpenstackNodeManager.this.localNodeId, leaderNodeId)) {
                return;
            }
            Device device = (Device)event.subject();
            ConnectionHandler<Device> handler = device.type().equals((Object)Device.Type.SWITCH) ? OpenstackNodeManager.this.bridgeHandler : OpenstackNodeManager.this.ovsdbHandler;
            switch ((DeviceEvent.Type)event.type()) {
                case PORT_ADDED: {
                    OpenstackNodeManager.this.eventExecutor.execute(() -> OpenstackNodeManager.this.bridgeHandler.portAdded(event.port()));
                    break;
                }
                case PORT_UPDATED: {
                    if (event.port().isEnabled()) break;
                    OpenstackNodeManager.this.eventExecutor.execute(() -> OpenstackNodeManager.this.bridgeHandler.portRemoved(event.port()));
                    break;
                }
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (OpenstackNodeManager.this.deviceService.isAvailable(device.id())) {
                        OpenstackNodeManager.this.eventExecutor.execute(() -> handler.connected(device));
                        break;
                    }
                    OpenstackNodeManager.this.eventExecutor.execute(() -> handler.disconnected(device));
                    OpenstackNodeManager.this.log.warn("OpenstackNode with device ID {} is disconnected", (Object)device.id());
                    break;
                }
            }
        }
    }

    private class BridgeHandler
    implements ConnectionHandler<Device> {
        private BridgeHandler() {
        }

        @Override
        public void connected(Device device) {
            OpenstackNode node = OpenstackNodeManager.this.nodeByDeviceId(device.id());
            if (node != null) {
                OpenstackNodeManager.this.setNodeState(node, OpenstackNodeManager.this.nodeState(node));
            } else {
                OpenstackNodeManager.this.log.debug("{} is detected on unregistered node, ignore it.", (Object)device.id());
            }
        }

        @Override
        public void disconnected(Device device) {
            OpenstackNode node = OpenstackNodeManager.this.nodeByDeviceId(device.id());
            if (node != null) {
                OpenstackNodeManager.this.log.warn("Device {} is disconnected", (Object)device.id());
                OpenstackNodeManager.this.setNodeState(node, OpenstackNodeEvent.NodeState.INCOMPLETE);
            }
        }

        public void portAdded(Port port) {
            OpenstackNode node = OpenstackNodeManager.this.nodeByDeviceId((DeviceId)port.element().id());
            String portName = port.annotations().value("portName");
            if (node == null) {
                OpenstackNodeManager.this.log.debug("{} is added to unregistered node, ignore it.", (Object)portName);
                return;
            }
            OpenstackNodeManager.this.log.info("Port {} is added to {}", (Object)portName, (Object)node.hostname());
            if (OpenstackNodeManager.this.systemIfaces(node).contains(portName)) {
                OpenstackNodeManager.this.setNodeState(node, OpenstackNodeManager.this.nodeState(node));
            }
        }

        public void portRemoved(Port port) {
            OpenstackNode node = OpenstackNodeManager.this.nodeByDeviceId((DeviceId)port.element().id());
            String portName = port.annotations().value("portName");
            if (node == null) {
                return;
            }
            OpenstackNodeManager.this.log.info("Port {} is removed from {}", (Object)portName, (Object)node.hostname());
            if (OpenstackNodeManager.this.systemIfaces(node).contains(portName)) {
                OpenstackNodeManager.this.setNodeState(node, OpenstackNodeEvent.NodeState.INCOMPLETE);
            }
        }
    }

    private class OvsdbHandler
    implements ConnectionHandler<Device> {
        private OvsdbHandler() {
        }

        @Override
        public void connected(Device device) {
            OpenstackNode node = OpenstackNodeManager.this.nodes().stream().filter(n -> n.ovsdbId().equals((Object)device.id())).findFirst().orElse(null);
            if (node != null) {
                OpenstackNodeManager.this.setNodeState(node, OpenstackNodeManager.this.nodeState(node));
            } else {
                OpenstackNodeManager.this.log.debug("{} is detected on unregistered node, ignore it.", (Object)device.id());
            }
        }

        @Override
        public void disconnected(Device device) {
            OpenstackNode node = OpenstackNodeManager.this.nodeByDeviceId(device.id());
            if (node != null) {
                OpenstackNodeManager.this.log.warn("Device {} is disconnected", (Object)device.id());
                OpenstackNodeManager.this.setNodeState(node, OpenstackNodeEvent.NodeState.INCOMPLETE);
            }
        }
    }
}

