/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;
import org.onosproject.openstacknode.OpenstackNode;
import org.onosproject.openstacknode.OpenstackNodeService;

public final class OpenstackNodeConfig
extends Config<ApplicationId> {
    private static final String NODES = "nodes";
    private static final String HOST_NAME = "hostname";
    private static final String TYPE = "type";
    private static final String MANAGEMENT_IP = "managementIp";
    private static final String DATA_IP = "dataIp";
    private static final String INTEGRATION_BRIDGE = "integrationBridge";
    private static final String ROUTER_BRIDGE = "routerBridge";
    private static final String UPLINK_PORT_NAME = "uplinkPort";
    private static final String ROUTER_CONTROLLER = "routerController";
    private static final String VLAN_PORT_NAME = "vlanPort";

    public boolean isValid() {
        boolean result = this.hasOnlyFields(new String[]{NODES});
        if (this.object.get(NODES) == null || this.object.get(NODES).size() < 1) {
            String msg = "No node is present";
            throw new IllegalArgumentException("No node is present");
        }
        for (JsonNode node : this.object.get(NODES)) {
            if (this.get(node, DATA_IP) == null && this.get(node, VLAN_PORT_NAME) == null) {
                String msg = "There is neither tunnel interface nor vlan port";
                throw new IllegalArgumentException("There is neither tunnel interface nor vlan port");
            }
            ObjectNode osNode = (ObjectNode)node;
            result &= this.hasOnlyFields(osNode, new String[]{HOST_NAME, TYPE, MANAGEMENT_IP, DATA_IP, INTEGRATION_BRIDGE, ROUTER_BRIDGE, UPLINK_PORT_NAME, ROUTER_CONTROLLER, VLAN_PORT_NAME});
            result &= this.isString(osNode, HOST_NAME, Config.FieldPresence.MANDATORY, new String[0]);
            result &= this.isString(osNode, TYPE, Config.FieldPresence.MANDATORY, new String[0]);
            result &= this.isIpAddress(osNode, MANAGEMENT_IP, Config.FieldPresence.MANDATORY);
            result &= this.isString(osNode, INTEGRATION_BRIDGE, Config.FieldPresence.MANDATORY, new String[0]);
            result &= this.isString(osNode, VLAN_PORT_NAME, Config.FieldPresence.OPTIONAL, new String[0]);
            result &= this.isIpAddress(osNode, DATA_IP, Config.FieldPresence.OPTIONAL);
            DeviceId.deviceId((String)osNode.get(INTEGRATION_BRIDGE).asText());
            OpenstackNodeService.NodeType.valueOf(osNode.get(TYPE).asText());
            if (!osNode.get(TYPE).asText().equals(OpenstackNodeService.NodeType.GATEWAY.name())) continue;
            result &= this.isString(osNode, ROUTER_BRIDGE, Config.FieldPresence.MANDATORY, new String[0]);
            DeviceId.deviceId((String)osNode.get(ROUTER_BRIDGE).asText());
            result &= this.isString(osNode, UPLINK_PORT_NAME, Config.FieldPresence.MANDATORY, new String[0]);
            result &= this.isIpAddress(osNode, ROUTER_CONTROLLER, Config.FieldPresence.MANDATORY);
        }
        return result;
    }

    public Set<OpenstackNode> openstackNodes() {
        HashSet nodes = Sets.newHashSet();
        for (JsonNode node : this.object.get(NODES)) {
            OpenstackNodeService.NodeType type = OpenstackNodeService.NodeType.valueOf(this.get(node, TYPE));
            OpenstackNode.Builder nodeBuilder = OpenstackNode.builder().integrationBridge(DeviceId.deviceId((String)this.get(node, INTEGRATION_BRIDGE))).managementIp(IpAddress.valueOf((String)this.get(node, MANAGEMENT_IP))).type(type).hostname(this.get(node, HOST_NAME));
            if (this.get(node, DATA_IP) != null) {
                nodeBuilder.dataIp(IpAddress.valueOf((String)this.get(node, DATA_IP)));
            }
            if (this.get(node, VLAN_PORT_NAME) != null) {
                nodeBuilder.vlanPort(this.get(node, VLAN_PORT_NAME));
            }
            if (type.equals((Object)OpenstackNodeService.NodeType.GATEWAY)) {
                nodeBuilder.routerBridge(DeviceId.deviceId((String)this.get(node, ROUTER_BRIDGE))).uplink(this.get(node, UPLINK_PORT_NAME)).routerController(IpAddress.valueOf((String)this.get(node, ROUTER_CONTROLLER)));
            }
            nodes.add(nodeBuilder.build());
        }
        return nodes;
    }

    private String get(JsonNode jsonNode, String path) {
        JsonNode jNode = jsonNode.get(path);
        if (jNode == null || jNode.isMissingNode()) {
            return null;
        }
        return jNode.asText();
    }
}

