/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openstacknode;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.openstacknode.OpenstackNodeEvent;
import org.onosproject.openstacknode.OpenstackNodeService;

public final class OpenstackNode {
    private final String hostname;
    private final OpenstackNodeService.NodeType type;
    private final IpAddress managementIp;
    private final Optional<IpAddress> dataIp;
    private final DeviceId integrationBridge;
    private final Optional<DeviceId> routerBridge;
    private final Optional<String> uplink;
    private final Optional<IpAddress> routerController;
    private final Optional<String> vlanPort;
    private final OpenstackNodeEvent.NodeState state;
    public static final Comparator<OpenstackNode> OPENSTACK_NODE_COMPARATOR = (node1, node2) -> node1.hostname().compareTo(node2.hostname());

    private OpenstackNode(String hostname, OpenstackNodeService.NodeType type, IpAddress managementIp, Optional<IpAddress> dataIp, DeviceId integrationBridge, Optional<DeviceId> routerBridge, Optional<String> uplink, Optional<IpAddress> routerController, Optional<String> vlanPort, OpenstackNodeEvent.NodeState state) {
        this.hostname = hostname;
        this.type = type;
        this.managementIp = managementIp;
        this.dataIp = dataIp;
        this.integrationBridge = integrationBridge;
        this.routerBridge = routerBridge;
        this.uplink = uplink;
        this.routerController = routerController;
        this.vlanPort = vlanPort;
        this.state = state;
    }

    public static OpenstackNode getUpdatedNode(OpenstackNode node, OpenstackNodeEvent.NodeState state) {
        return new OpenstackNode(node.hostname, node.type, node.managementIp, node.dataIp, node.integrationBridge, node.routerBridge, node.uplink, node.routerController, node.vlanPort, state);
    }

    public String hostname() {
        return this.hostname;
    }

    public OpenstackNodeService.NodeType type() {
        return this.type;
    }

    public IpAddress managementIp() {
        return this.managementIp;
    }

    public Optional<IpAddress> dataIp() {
        return this.dataIp;
    }

    public DeviceId intBridge() {
        return this.integrationBridge;
    }

    public Optional<DeviceId> routerBridge() {
        return this.routerBridge;
    }

    public Optional<IpAddress> routerController() {
        return this.routerController;
    }

    public Optional<String> uplink() {
        return this.uplink;
    }

    public Optional<String> vlanPort() {
        return this.vlanPort;
    }

    public OpenstackNodeEvent.NodeState state() {
        return this.state;
    }

    public DeviceId ovsdbId() {
        return DeviceId.deviceId((String)("ovsdb:" + this.managementIp.toString()));
    }

    public Optional<String> externalPortName() {
        if (this.type == OpenstackNodeService.NodeType.GATEWAY) {
            return Optional.of("patch-intg");
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OpenstackNode) {
            OpenstackNode that = (OpenstackNode)obj;
            if (Objects.equals(this.hostname, that.hostname) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.managementIp, that.managementIp) && Objects.equals(this.dataIp, that.dataIp) && Objects.equals(this.integrationBridge, that.integrationBridge) && Objects.equals(this.routerBridge, that.routerBridge) && Objects.equals(this.uplink, that.uplink) && Objects.equals(this.routerController, that.routerController) && Objects.equals(this.vlanPort, that.vlanPort)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hostname, this.type, this.managementIp, this.dataIp, this.integrationBridge, this.routerBridge, this.uplink, this.routerController, this.vlanPort});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("hostname", (Object)this.hostname).add("type", (Object)this.type).add("managementIp", (Object)this.managementIp).add("dataIp", this.dataIp).add("integrationBridge", (Object)this.integrationBridge).add("routerBridge", this.routerBridge).add("uplink", this.uplink).add("routerController", this.routerController).add("vlanport", this.vlanPort).add("state", (Object)this.state).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String hostname;
        private OpenstackNodeService.NodeType type;
        private IpAddress managementIp;
        private Optional<IpAddress> dataIp = Optional.empty();
        private DeviceId integrationBridge;
        private Optional<DeviceId> routerBridge = Optional.empty();
        private Optional<String> uplink = Optional.empty();
        private Optional<String> vlanPort = Optional.empty();
        private Optional<IpAddress> routerController = Optional.empty();
        private OpenstackNodeEvent.NodeState state = OpenstackNodeEvent.NodeState.INIT;

        private Builder() {
        }

        public OpenstackNode build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.hostname) ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)((Object)this.type));
            Preconditions.checkNotNull((Object)this.managementIp);
            Preconditions.checkNotNull(this.dataIp);
            Preconditions.checkNotNull((Object)this.integrationBridge);
            Preconditions.checkNotNull(this.routerBridge);
            Preconditions.checkNotNull(this.uplink);
            Preconditions.checkNotNull(this.routerController);
            Preconditions.checkNotNull(this.vlanPort);
            if (this.type == OpenstackNodeService.NodeType.GATEWAY) {
                Preconditions.checkArgument((boolean)this.routerBridge.isPresent());
                Preconditions.checkArgument((boolean)this.uplink.isPresent());
                Preconditions.checkArgument((boolean)this.routerController.isPresent());
            }
            return new OpenstackNode(this.hostname, this.type, this.managementIp, this.dataIp, this.integrationBridge, this.routerBridge, this.uplink, this.routerController, this.vlanPort, this.state);
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder type(OpenstackNodeService.NodeType type) {
            this.type = type;
            return this;
        }

        public Builder managementIp(IpAddress managementIp) {
            this.managementIp = managementIp;
            return this;
        }

        public Builder dataIp(IpAddress dataIp) {
            this.dataIp = Optional.ofNullable(dataIp);
            return this;
        }

        public Builder integrationBridge(DeviceId integrationBridge) {
            this.integrationBridge = integrationBridge;
            return this;
        }

        public Builder routerBridge(DeviceId routerBridge) {
            this.routerBridge = Optional.ofNullable(routerBridge);
            return this;
        }

        public Builder uplink(String uplink) {
            this.uplink = Optional.ofNullable(uplink);
            return this;
        }

        public Builder routerController(IpAddress routerController) {
            this.routerController = Optional.ofNullable(routerController);
            return this;
        }

        public Builder vlanPort(String vlanPort) {
            this.vlanPort = Optional.ofNullable(vlanPort);
            return this;
        }

        public Builder state(OpenstackNodeEvent.NodeState state) {
            this.state = state;
            return this;
        }
    }
}

