/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.joda.time.LocalDateTime;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.event.Event;
import org.onosproject.events.EventHistoryService;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyEvent;

@Command(scope="onos", name="events", description="Command to print history of instance local ONOS Events")
public class EventsCommand
extends AbstractShellCommand {
    @Option(name="--all", aliases={"-a"}, description="Include all Events (default behavior)", required=false)
    private boolean all = false;
    @Option(name="--mastership", aliases={"-m"}, description="Include MastershipEvent", required=false)
    private boolean mastership = false;
    @Option(name="--device", aliases={"-d"}, description="Include DeviceEvent", required=false)
    private boolean device = false;
    @Option(name="--link", aliases={"-l"}, description="Include LinkEvent", required=false)
    private boolean link = false;
    @Option(name="--topology", aliases={"-t"}, description="Include TopologyEvent", required=false)
    private boolean topology = false;
    @Option(name="--host", aliases={"-t"}, description="Include HostEvent", required=false)
    private boolean host = false;
    @Option(name="--cluster", aliases={"-c"}, description="Include ClusterEvent", required=false)
    private boolean cluster = false;
    @Option(name="--max-events", aliases={"-n"}, description="Maximum number of events to print", required=false, valueToShowInHelp="-1 [no limit]")
    private long maxSize = -1L;

    protected void execute() {
        boolean dumpAll;
        EventHistoryService eventHistoryService = (EventHistoryService)EventsCommand.get(EventHistoryService.class);
        Stream<Object> events = eventHistoryService.history().stream();
        boolean bl = dumpAll = this.all || !this.mastership && !this.device && !this.link && !this.topology && !this.host;
        if (!dumpAll) {
            Predicate<Event> filter = defaultIs -> false;
            if (this.mastership) {
                filter = filter.or(evt -> evt instanceof MastershipEvent);
            }
            if (this.device) {
                filter = filter.or(evt -> evt instanceof DeviceEvent);
            }
            if (this.link) {
                filter = filter.or(evt -> evt instanceof LinkEvent);
            }
            if (this.topology) {
                filter = filter.or(evt -> evt instanceof TopologyEvent);
            }
            if (this.host) {
                filter = filter.or(evt -> evt instanceof HostEvent);
            }
            if (this.cluster) {
                filter = filter.or(evt -> evt instanceof ClusterEvent);
            }
            events = events.filter(filter);
        }
        if (this.maxSize > 0L) {
            events = events.limit(this.maxSize);
        }
        if (this.outputJson()) {
            ArrayNode jsonEvents = events.map(this::json).collect(this.toArrayNode());
            this.printJson((JsonNode)jsonEvents);
        } else {
            events.forEach(this::printEvent);
        }
    }

    private Collector<JsonNode, ArrayNode, ArrayNode> toArrayNode() {
        return Collector.of(() -> this.mapper().createArrayNode(), ArrayNode::add, ArrayNode::addAll, new Collector.Characteristics[0]);
    }

    private ObjectNode json(Event<?, ?> event) {
        ObjectNode result = this.mapper().createObjectNode();
        result.put("time", event.time()).put("type", event.type().toString()).put("event", event.toString());
        return result;
    }

    private void printJson(JsonNode json) {
        try {
            this.print("%s", new Object[]{this.mapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json)});
        }
        catch (JsonProcessingException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.print("[ERROR] %s\n%s", new Object[]{e.getMessage(), sw.toString()});
        }
    }

    private void printEvent(Event<?, ?> event) {
        if (event instanceof DeviceEvent) {
            DeviceEvent deviceEvent = (DeviceEvent)event;
            if (event.type().toString().startsWith("PORT")) {
                this.print("%s %s\t%s/%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), ((Device)deviceEvent.subject()).id(), deviceEvent.port().number(), deviceEvent.port()});
            } else {
                this.print("%s %s\t%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), ((Device)deviceEvent.subject()).id(), deviceEvent.subject()});
            }
        } else if (event instanceof MastershipEvent) {
            this.print("%s %s\t%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), event.subject(), ((MastershipEvent)event).roleInfo()});
        } else if (event instanceof LinkEvent) {
            LinkEvent linkEvent = (LinkEvent)event;
            Link link = (Link)linkEvent.subject();
            this.print("%s %s\t%s/%s-%s/%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), link.src().deviceId(), link.src().port(), link.dst().deviceId(), link.dst().port(), link});
        } else if (event instanceof HostEvent) {
            HostEvent hostEvent = (HostEvent)event;
            this.print("%s %s\t%s [%s->%s]", new Object[]{new LocalDateTime(event.time()), event.type(), ((Host)hostEvent.subject()).id(), hostEvent.prevSubject(), hostEvent.subject()});
        } else if (event instanceof TopologyEvent) {
            TopologyEvent topoEvent = (TopologyEvent)event;
            List reasons = (List)MoreObjects.firstNonNull((Object)topoEvent.reasons(), (Object)ImmutableList.of());
            Topology topo = (Topology)topoEvent.subject();
            String summary = String.format("(d=%d,l=%d,c=%d)", topo.deviceCount(), topo.linkCount(), topo.clusterCount());
            this.print("%s %s%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), summary, reasons.stream().map(e -> e.type()).collect(Collectors.toList())});
        } else if (event instanceof ClusterEvent) {
            this.print("%s %s\t%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), ((ControllerNode)((ClusterEvent)event).subject()).id(), event.subject()});
        } else {
            this.print("%s %s\t%s [%s]", new Object[]{new LocalDateTime(event.time()), event.type(), event.subject(), event});
        }
    }
}

