/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.events;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onlab.util.UnmodifiableDeque;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerService;
import org.onosproject.event.ListenerTracker;
import org.onosproject.events.EventHistoryService;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.edge.EdgePortListener;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class EventHistoryManager
implements EventHistoryService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EdgePortService edgeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netcfgService;
    @Property(name="excludeStatsEvent", boolValue={true}, label="Exclude stats related events")
    private boolean excludeStatsEvent = true;
    @Property(name="sizeLimit", intValue={10000}, label="Number of event history to store")
    private int sizeLimit = 10000;
    private ApplicationId appId;
    private ListenerTracker listeners;
    private final Deque<Event<?, ?>> history = new ConcurrentLinkedDeque();
    private ScheduledExecutorService pruner;
    private long pruneInterval = 5L;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.events");
        this.log.debug("Registered as {}", (Object)this.appId);
        this.pruner = Executors.newSingleThreadScheduledExecutor(Tools.minPriority((ThreadFactory)Tools.groupedThreads((String)"onos/events", (String)"history-pruner", (Logger)this.log)));
        this.pruner.scheduleWithFixedDelay(this::pruneEventHistoryTask, this.pruneInterval, this.pruneInterval, TimeUnit.SECONDS);
        this.listeners = new ListenerTracker();
        this.listeners.addListener((ListenerService)this.mastershipService, (EventListener)((MastershipListener)this::addEvent)).addListener((ListenerService)this.deviceService, (EventListener)new InternalDeviceListener()).addListener((ListenerService)this.linkService, (EventListener)((LinkListener)this::addEvent)).addListener((ListenerService)this.topologyService, (EventListener)((TopologyListener)this::addEvent)).addListener((ListenerService)this.hostService, (EventListener)((HostListener)this::addEvent)).addListener((ListenerService)this.clusterService, (EventListener)((ClusterEventListener)this::addEvent)).addListener((ListenerService)this.edgeService, (EventListener)((EdgePortListener)this::addEvent)).addListener((ListenerService)this.netcfgService, (EventListener)((NetworkConfigListener)this::addEvent));
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.listeners.removeListeners();
        this.pruner.shutdownNow();
        this.history.clear();
        this.log.info("Stopped");
    }

    @Override
    public Deque<Event<?, ?>> history() {
        return UnmodifiableDeque.unmodifiableDeque(this.history);
    }

    @Override
    public void clear() {
        this.history.clear();
    }

    private void pruneEventHistoryTask() {
        int size = this.history.size();
        int overflows = size - this.sizeLimit;
        if (overflows > 0) {
            for (int i = 0; i < overflows; ++i) {
                this.history.poll();
            }
        }
    }

    private void addEvent(Event<?, ?> event) {
        this.history.offer(event);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindEdgeService(EdgePortService edgePortService) {
        this.edgeService = edgePortService;
    }

    protected void unbindEdgeService(EdgePortService edgePortService) {
        if (this.edgeService == edgePortService) {
            this.edgeService = null;
        }
    }

    protected void bindNetcfgService(NetworkConfigService networkConfigService) {
        this.netcfgService = networkConfigService;
    }

    protected void unbindNetcfgService(NetworkConfigService networkConfigService) {
        if (this.netcfgService == networkConfigService) {
            this.netcfgService = null;
        }
    }

    class InternalDeviceListener
    implements DeviceListener {
        InternalDeviceListener() {
        }

        public boolean isRelevant(DeviceEvent event) {
            if (EventHistoryManager.this.excludeStatsEvent) {
                return event.type() != DeviceEvent.Type.PORT_STATS_UPDATED;
            }
            return true;
        }

        public void event(DeviceEvent event) {
            EventHistoryManager.this.addEvent((Event)event);
        }
    }
}

