/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.model.SingleInstanceNodeContext;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.AppModuleInfo;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangModelRegistry
implements YangModelRegistry,
SingleInstanceNodeContext {
    private static final String AT = "@";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, ConcurrentMap<String, YangSchemaNode>> yangSchemaStore;
    private final ConcurrentMap<String, YangSchemaNode> regClassNameKeyStore;
    private final ConcurrentMap<String, YangSchemaNode> qNameKeyStore;
    private final ConcurrentMap<String, Class<?>> registerClassStore;
    private final ConcurrentMap<String, YangSchemaNode> nameSpaceSchemaStore;
    private final Set<YangModel> models = new LinkedHashSet<YangModel>();

    public DefaultYangModelRegistry() {
        this.yangSchemaStore = new ConcurrentHashMap<String, ConcurrentMap<String, YangSchemaNode>>();
        this.regClassNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.registerClassStore = new ConcurrentHashMap();
        this.nameSpaceSchemaStore = new ConcurrentHashMap<String, YangSchemaNode>();
        this.qNameKeyStore = new ConcurrentHashMap<String, YangSchemaNode>();
    }

    @Override
    public void registerModel(ModelRegistrationParam param) {
        YangModel model = (YangModel)Preconditions.checkNotNull((Object)param.getYangModel(), (Object)"Model must not be null");
        Set<YangNode> curNodes = RuntimeHelper.getNodes(model);
        this.models.add(model);
        for (YangModuleId id : model.getYangModulesId()) {
            Class<?> service;
            String name;
            AppModuleInfo info = param.getAppModuleInfo(id);
            if (info == null || this.registerClassStore.containsKey(name = (service = info.getModuleClass()).getName())) continue;
            this.registerClassStore.put(name, service);
        }
        this.registerModule(curNodes);
        this.updateChildContext(curNodes);
    }

    private void registerModule(Set<YangNode> curNodes) {
        if (curNodes != null && !curNodes.isEmpty()) {
            for (YangNode node : curNodes) {
                String name = RuntimeHelper.getInterfaceClassName(node);
                if (!this.regClassNameKeyStore.containsKey(name)) {
                    this.processApplicationContext(node, name);
                    continue;
                }
                this.log.info("class already registered with model registry {}", (Object)name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterModel(ModelRegistrationParam param) {
        Class<DefaultYangModelRegistry> clazz = DefaultYangModelRegistry.class;
        synchronized (DefaultYangModelRegistry.class) {
            YangModel model = (YangModel)Preconditions.checkNotNull((Object)param.getYangModel(), (Object)"Model must not be null");
            this.models.remove(model);
            Set<YangNode> curNodes = RuntimeHelper.getNodes(model);
            for (YangNode node : curNodes) {
                this.processUnReg(RuntimeHelper.getInterfaceClassName(node));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void processUnReg(String serviceName) {
        YangSchemaNode curNode = (YangSchemaNode)this.regClassNameKeyStore.get(serviceName);
        if (curNode != null) {
            this.removeSchemaNode(curNode);
            this.regClassNameKeyStore.remove(serviceName);
            this.qNameKeyStore.remove(serviceName.toLowerCase());
            this.nameSpaceSchemaStore.remove(curNode.getNameSpace().getModuleNamespace());
            this.registerClassStore.remove(serviceName);
            this.log.info(" service class {} of model is unregistered.", (Object)serviceName);
        } else {
            this.log.error("Either {} service was not registered or already unregistered from model registry.", (Object)serviceName);
        }
    }

    @Override
    public Set<YangModel> getModels() {
        return Collections.unmodifiableSet(this.models);
    }

    YangSchemaNode getForSchemaName(String schemaName) {
        return this.getForNameWithRev(schemaName);
    }

    YangSchemaNode getForRegClassName(String name) {
        YangSchemaNode node = (YangSchemaNode)this.regClassNameKeyStore.get(name);
        if (node == null) {
            this.log.error("{} not found.", (Object)name);
        }
        return node;
    }

    YangSchemaNode getForRegClassQualifiedName(String pkg, boolean isFromDnb) {
        YangSchemaNode node = (YangSchemaNode)this.qNameKeyStore.get(pkg);
        if (node == null && !isFromDnb) {
            this.log.error("{} not found.", (Object)pkg);
        }
        return node;
    }

    public YangSchemaNode getForNameSpace(String nameSpace, boolean isForChildContext) {
        YangSchemaNode node = (YangSchemaNode)this.nameSpaceSchemaStore.get(nameSpace);
        if (node == null && !isForChildContext) {
            this.log.error("node with {} namespace not found.", (Object)nameSpace);
        }
        return node;
    }

    Class<?> getRegisteredClass(YangSchemaNode schemaNode) {
        Class regClass = null;
        if (schemaNode != null) {
            String interfaceName = RuntimeHelper.getInterfaceClassName(schemaNode);
            String serviceName = RuntimeHelper.getServiceName(schemaNode);
            regClass = (Class)this.registerClassStore.get(serviceName);
            if (regClass == null) {
                regClass = (Class)this.registerClassStore.get(interfaceName);
            }
        }
        if (regClass == null) {
            this.log.error("{} node should not be null.");
        }
        return regClass;
    }

    void processApplicationContext(YangSchemaNode appNode, String name) {
        this.addToSchemaStore(appNode);
        this.regClassNameKeyStore.put(name, appNode);
        this.qNameKeyStore.put(RuntimeHelper.getInterfaceClassName(appNode).toLowerCase(), appNode);
        this.nameSpaceSchemaStore.put(appNode.getNameSpace().getModuleNamespace(), appNode);
        this.log.info("successfully registered this application {}", (Object)name);
    }

    private YangSchemaNode getForNameWithRev(String name) {
        ConcurrentMap revMap;
        if (name.contains(AT)) {
            String[] revArray = name.split(AT);
            ConcurrentMap revMap2 = (ConcurrentMap)this.yangSchemaStore.get(revArray[0]);
            YangSchemaNode schemaNode = (YangSchemaNode)revMap2.get(name);
            if (schemaNode == null) {
                this.log.error("{} not found.", (Object)name);
            }
            return schemaNode;
        }
        if (this.yangSchemaStore.containsKey(name) && (revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty()) {
            YangSchemaNode node = (YangSchemaNode)revMap.get(name);
            if (node != null) {
                return node;
            }
            String revName = this.getLatestVersion(revMap);
            return (YangSchemaNode)revMap.get(revName);
        }
        this.log.error("{} not found.", (Object)name);
        return null;
    }

    private String getLatestVersion(ConcurrentMap<String, YangSchemaNode> revMap) {
        ArrayList keys = new ArrayList();
        for (Map.Entry entry : revMap.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys);
        return (String)keys.get(keys.size() - 1);
    }

    private void addToSchemaStore(YangSchemaNode schemaNode) {
        String name;
        String date = DataModelUtils.getDateInStringFormat((YangNode)schemaNode);
        String revName = name = schemaNode.getName();
        if (date != null) {
            revName = name + AT + date;
        }
        if (!this.yangSchemaStore.containsKey(name)) {
            ConcurrentHashMap<String, YangSchemaNode> revStore = new ConcurrentHashMap<String, YangSchemaNode>();
            revStore.put(revName, schemaNode);
            this.yangSchemaStore.put(name, revStore);
        } else {
            ((ConcurrentMap)this.yangSchemaStore.get(name)).put(revName, schemaNode);
        }
    }

    private void removeSchemaNode(YangSchemaNode removableNode) {
        ConcurrentMap revMap;
        String name;
        String revName = name = removableNode.getName();
        String date = DataModelUtils.getDateInStringFormat((YangNode)removableNode);
        if (date != null) {
            revName = name + AT + date;
        }
        if ((revMap = (ConcurrentMap)this.yangSchemaStore.get(name)) != null && !revMap.isEmpty() && revMap.size() != 1) {
            revMap.remove(revName);
        } else {
            this.yangSchemaStore.remove(removableNode.getName());
        }
    }

    public SchemaContext getParentContext() {
        return null;
    }

    public DataNode.Type getType() {
        return DataNode.Type.SINGLE_INSTANCE_NODE;
    }

    public SchemaId getSchemaId() {
        return new SchemaId("/", null);
    }

    private void updateChildContext(Set<YangNode> nodes) {
        for (YangNode node : nodes) {
            node.setLeafRootContext((SchemaContext)this);
            for (YangNode child = node.getChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof YangChoice) {
                    this.updateSchemaContextForChoiceChild(child);
                    continue;
                }
                if (!(child instanceof SchemaDataNode)) continue;
                child.setRootContext((SchemaContext)this);
            }
        }
    }

    private void updateContextForChoiceCase(YangNode child) {
        while (child != null) {
            if (child instanceof YangChoice) {
                this.updateSchemaContextForChoiceChild(child);
            } else if (child instanceof SchemaDataNode) {
                child.setRootContext((SchemaContext)this);
            }
            child = child.getNextSibling();
        }
    }

    private void updateSchemaContextForChoiceChild(YangNode curNode) {
        for (YangNode child = curNode.getChild(); child != null; child = child.getNextSibling()) {
            this.updateSchemaContextForCaseChild(child);
        }
    }

    private void updateSchemaContextForCaseChild(YangNode curNode) {
        curNode.setLeafRootContext((SchemaContext)this);
        YangNode child = curNode.getChild();
        this.updateContextForChoiceCase(child);
    }

    public SchemaContext getChildContext(SchemaId schemaId) {
        String namespace;
        YangSchemaNode node;
        Preconditions.checkNotNull((Object)schemaId);
        if (schemaId.namespace() == null) {
            this.log.error("node with {} namespace not found.", (Object)schemaId.namespace());
        }
        if ((node = this.getForNameSpace(namespace = schemaId.namespace(), true)) == null) {
            node = this.getForSchemaName(schemaId.namespace());
        }
        YangSchemaNodeIdentifier id = DataModelUtils.getNodeIdFromSchemaId(schemaId, namespace);
        try {
            if (node != null) {
                return node.getChildSchema(id).getSchemaNode();
            }
            this.log.error("node with {} namespace not found.", (Object)schemaId.namespace());
        }
        catch (DataModelException e) {
            this.log.error("failed to get child schema", (Throwable)e);
        }
        return null;
    }
}

