/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.utils.io.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.onosproject.yang.compiler.utils.UtilConstants;
import org.onosproject.yang.compiler.utils.io.YangToJavaNamingConflictUtil;
import org.onosproject.yang.compiler.utils.io.impl.CopyrightHeader;
import org.onosproject.yang.compiler.utils.io.impl.FileSystemUtil;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangIoUtils {
    private static final int LINE_SIZE = 118;
    private static final int SUB_LINE_SIZE = 116;
    private static final int SUB_SIZE = 60;
    private static final Logger log = LoggerFactory.getLogger(YangIoUtils.class);

    private YangIoUtils() {
    }

    public static File createDirectories(String path) throws IOException {
        boolean isGenerated;
        File generatedDir = new File(path);
        if (!generatedDir.exists() && !(isGenerated = generatedDir.mkdirs())) {
            throw new IOException("failed to generated directory " + path);
        }
        return generatedDir;
    }

    public static void addPackageInfo(File path, String classInfo, String pack, boolean isChildNode) throws IOException {
        pack = YangIoUtils.parsePkg(pack);
        try {
            boolean isGenerated;
            File packageInfo = new File(path + UtilConstants.SLASH + "package-info.java");
            if (!packageInfo.exists() && !(isGenerated = packageInfo.createNewFile())) {
                throw new IOException("failed to generated package-info " + path);
            }
            FileWriter fileWriter = new FileWriter(packageInfo);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(CopyrightHeader.parseCopyrightHeader());
            bufferedWriter.write(JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.PACKAGE_INFO, classInfo, isChildNode, null));
            String pkg = "package " + pack + ";";
            bufferedWriter.write(pkg);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException e) {
            throw new IOException("Exception occurred while creating package info file.");
        }
    }

    public static String parsePkg(String pack) {
        if (pack.contains("org")) {
            String[] strArray = pack.split("org");
            if (strArray.length >= 3) {
                for (int i = 1; i < strArray.length; ++i) {
                    pack = i == 1 ? "org" + strArray[1] : pack + "org" + strArray[i];
                }
            } else {
                pack = "org" + strArray[1];
            }
        }
        return pack;
    }

    public static void deleteDirectory(String dir) throws IOException {
        File generatedDirectory = new File(dir);
        if (generatedDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)generatedDirectory);
            }
            catch (IOException e) {
                throw new IOException("Failed to delete the generated files in " + generatedDirectory + " directory");
            }
        }
    }

    public static void searchAndDeleteTempDir(String root) throws IOException {
        LinkedList<File> store = new LinkedList<File>();
        Stack<String> stack = new Stack<String>();
        stack.push(root);
        while (!stack.empty()) {
            root = (String)stack.pop();
            File file = new File(root);
            File[] fileList = file.listFiles();
            if (fileList == null || fileList.length == 0) continue;
            for (File current : fileList) {
                if (!current.isDirectory()) continue;
                stack.push(current.toString());
                if (!current.getName().endsWith("-Temp")) continue;
                store.add(current);
            }
        }
        for (File dir : store) {
            FileUtils.deleteDirectory((File)dir);
        }
    }

    public static String trimAtLast(String valueString, String ... removalString) {
        StringBuilder stringBuilder = new StringBuilder(valueString);
        for (String remove : removalString) {
            String midString = stringBuilder.toString();
            int index = midString.lastIndexOf(remove);
            if (index == -1) continue;
            stringBuilder.deleteCharAt(index);
        }
        return stringBuilder.toString();
    }

    public static String replaceLast(String valueString, String removalString, String replacingString) {
        StringBuilder stringBuilder = new StringBuilder(valueString);
        int index = valueString.lastIndexOf(removalString);
        if (index != -1) {
            stringBuilder.replace(index, index + 1, replacingString);
        } else {
            stringBuilder.append("\n        UNUSED(1);");
        }
        return stringBuilder.toString();
    }

    public static String getDirectory(String baseCodeGenPath, String pathOfJavaPkg) {
        String[] strArray;
        if (pathOfJavaPkg.charAt(pathOfJavaPkg.length() - 1) == File.separatorChar) {
            pathOfJavaPkg = YangIoUtils.trimAtLast(pathOfJavaPkg, UtilConstants.SLASH);
        }
        if ((strArray = pathOfJavaPkg.split(UtilConstants.SLASH))[0].equals("")) {
            return pathOfJavaPkg;
        }
        return baseCodeGenPath + UtilConstants.SLASH + pathOfJavaPkg;
    }

    public static String getAbsolutePackagePath(String baseCodeGenPath, String pathOfJavaPkg) {
        return baseCodeGenPath + pathOfJavaPkg;
    }

    public static void mergeJavaFiles(File appendFile, File srcFile) throws IOException {
        try {
            FileSystemUtil.appendFileContents(appendFile, srcFile);
        }
        catch (IOException e) {
            throw new IOException("Failed to merge " + appendFile + " in " + srcFile);
        }
    }

    public static void insertDataIntoJavaFile(File file, String data) throws IOException {
        try {
            FileSystemUtil.updateFileHandle(file, data, false);
        }
        catch (IOException e) {
            throw new IOException("Failed to insert in " + file + "file");
        }
    }

    public static File formatFile(File dataFile) throws IOException {
        return dataFile;
    }

    public static String getJavaPackageFromPackagePath(String packagePath) {
        return packagePath.replace(UtilConstants.SLASH, ".");
    }

    public static String getPackageDirPathFromJavaJPackage(String packagePath) {
        return packagePath.replace(".", UtilConstants.SLASH);
    }

    public static String getSmallCase(String yangIdentifier) {
        return yangIdentifier.substring(0, 1).toLowerCase() + yangIdentifier.substring(1);
    }

    public static String getCapitalCase(String yangIdentifier) {
        yangIdentifier = yangIdentifier.substring(0, 1).toUpperCase() + yangIdentifier.substring(1);
        return YangIoUtils.restrictConsecutiveCapitalCase(yangIdentifier);
    }

    private static String restrictConsecutiveCapitalCase(String consecCapitalCaseRemover) {
        for (int k = 0; k < consecCapitalCaseRemover.length(); ++k) {
            if (k + 1 >= consecCapitalCaseRemover.length() || !Character.isUpperCase(consecCapitalCaseRemover.charAt(k)) || !Character.isUpperCase(consecCapitalCaseRemover.charAt(k + 1))) continue;
            consecCapitalCaseRemover = consecCapitalCaseRemover.substring(0, k + 1) + consecCapitalCaseRemover.substring(k + 1, k + 2).toLowerCase() + consecCapitalCaseRemover.substring(k + 2);
        }
        return consecCapitalCaseRemover;
    }

    private static String addPrefix(String camelCasePrefix, YangToJavaNamingConflictUtil conflictResolver) {
        String prefix = YangIoUtils.getPrefixForIdentifier(conflictResolver);
        if (camelCasePrefix.matches("\\d.*")) {
            camelCasePrefix = prefix + camelCasePrefix;
        }
        if (UtilConstants.JAVA_KEY_WORDS.contains(camelCasePrefix)) {
            camelCasePrefix = prefix + camelCasePrefix.substring(0, 1).toUpperCase() + camelCasePrefix.substring(1);
        }
        return camelCasePrefix;
    }

    private static String applyCamelCaseRule(String[] stringArray, YangToJavaNamingConflictUtil conflictResolver) {
        int i;
        String ruleChecker = stringArray[0].toLowerCase();
        if (ruleChecker.matches("\\d.*")) {
            i = 0;
            ruleChecker = "";
        } else {
            i = 1;
        }
        while (i < stringArray.length) {
            if (i + 1 == stringArray.length && (stringArray[i].matches("[a-zA-Z]") || stringArray[i].matches("[0-9]+[a-zA-Z]"))) {
                ruleChecker = ruleChecker + stringArray[i].toLowerCase();
                break;
            }
            if (stringArray[i].matches("\\d.*")) {
                for (int j = 0; j < stringArray[i].length(); ++j) {
                    char letterCheck = stringArray[i].charAt(j);
                    if (!Character.isLetter(letterCheck)) continue;
                    stringArray[i] = stringArray[i].substring(0, j) + stringArray[i].substring(j, j + 1).toUpperCase() + stringArray[i].substring(j + 1);
                    break;
                }
                ruleChecker = ruleChecker + stringArray[i];
            } else {
                ruleChecker = ruleChecker + stringArray[i].substring(0, 1).toUpperCase() + stringArray[i].substring(1);
            }
            ++i;
        }
        String ruleCheckerWithPrefix = YangIoUtils.addPrefix(ruleChecker, conflictResolver);
        return YangIoUtils.restrictConsecutiveCapitalCase(ruleCheckerWithPrefix);
    }

    private static String upperCaseConflictResolver(String[] stringArray, YangToJavaNamingConflictUtil conflictResolver) {
        for (int l = 0; l < stringArray.length; ++l) {
            String[] upperCaseSplitArray = stringArray[l].split("(?=\\p{Upper})");
            block1: for (int m = 0; m < upperCaseSplitArray.length; ++m) {
                if (!upperCaseSplitArray[m].matches("[A-Z]")) continue;
                int check = m;
                while (check + 1 < upperCaseSplitArray.length) {
                    if (upperCaseSplitArray[check + 1].matches("[A-Z]")) {
                        upperCaseSplitArray[check + 1] = upperCaseSplitArray[check + 1].toLowerCase();
                        ++check;
                        continue;
                    }
                    if (!upperCaseSplitArray[check + 1].matches("[A-Z][0-9a-z]+")) continue block1;
                    upperCaseSplitArray[check + 1] = upperCaseSplitArray[check + 1].toLowerCase();
                    continue block1;
                }
            }
            StringBuilder strBuilder = new StringBuilder();
            for (String element : upperCaseSplitArray) {
                strBuilder.append(element);
            }
            stringArray[l] = strBuilder.toString();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String element : stringArray) {
            String[] capitalCaseSplitArray;
            for (String letter : capitalCaseSplitArray = element.split("(?=\\p{Upper})")) {
                String[] arrayForAddition = letter.split("(?=\\d+)");
                List<String> list = Arrays.asList(arrayForAddition);
                for (String str : list) {
                    if (str == null || str.isEmpty()) continue;
                    result.add(str);
                }
            }
        }
        stringArray = result.toArray(new String[result.size()]);
        return YangIoUtils.applyCamelCaseRule(stringArray, conflictResolver);
    }

    public static String getCamelCase(String yangIdentifier, YangToJavaNamingConflictUtil conflictResolver) {
        String[] strArray;
        if (conflictResolver != null) {
            String replacementForHyphen = conflictResolver.getReplacementForHyphen();
            String replacementForPeriod = conflictResolver.getReplacementForPeriod();
            String replacementForUnderscore = conflictResolver.getReplacementForUnderscore();
            if (replacementForPeriod != null) {
                yangIdentifier = yangIdentifier.replaceAll("[.]", "." + replacementForPeriod.toLowerCase() + ".");
            }
            if (replacementForUnderscore != null) {
                yangIdentifier = yangIdentifier.replaceAll("[_]", "_" + replacementForUnderscore.toLowerCase() + "_");
            }
            if (replacementForHyphen != null) {
                yangIdentifier = yangIdentifier.replaceAll("[-]", "-" + replacementForHyphen.toLowerCase() + "-");
            }
        }
        if ((strArray = (yangIdentifier = yangIdentifier.replaceAll("[. _ -]+", ":")).split(":"))[0].isEmpty()) {
            ArrayList<String> stringArrangement = new ArrayList<String>();
            stringArrangement.addAll(Arrays.asList(strArray).subList(1, strArray.length));
            strArray = stringArrangement.toArray(new String[stringArrangement.size()]);
        }
        return YangIoUtils.upperCaseConflictResolver(strArray, conflictResolver);
    }

    public static String getPrefixForIdentifier(YangToJavaNamingConflictUtil conflictResolver) {
        String prefixForIdentifier = null;
        if (conflictResolver != null) {
            prefixForIdentifier = conflictResolver.getPrefixForIdentifier();
        }
        if (prefixForIdentifier != null) {
            prefixForIdentifier = prefixForIdentifier.replaceAll("[\\p{Punct}\\s]+", ":");
            String[] strArray = prefixForIdentifier.split(":");
            try {
                if (strArray[0].isEmpty()) {
                    ArrayList<String> stringArrangement = new ArrayList<String>();
                    stringArrangement.addAll(Arrays.asList(strArray).subList(1, strArray.length));
                    strArray = stringArrangement.toArray(new String[stringArrangement.size()]);
                }
                prefixForIdentifier = strArray[0];
                for (int j = 1; j < strArray.length; ++j) {
                    prefixForIdentifier = prefixForIdentifier + strArray[j].substring(0, 1).toUpperCase() + strArray[j].substring(1);
                }
            }
            catch (ArrayIndexOutOfBoundsException outOfBoundsException) {
                throw new ArrayIndexOutOfBoundsException("The given prefix in pom.xml is invalid.");
            }
        } else {
            prefixForIdentifier = "yangAutoPrefix";
        }
        return prefixForIdentifier;
    }

    public static void removeEmptyDirectory(String path) {
        while (path != null && !path.isEmpty() && YangIoUtils.removeDirectory(path)) {
            int index = path.lastIndexOf(UtilConstants.SLASH);
            path = path.substring(0, index);
        }
    }

    private static boolean removeDirectory(String path) {
        File dir = new File(path);
        boolean isDeleted = false;
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null && files.length == 0) {
                isDeleted = dir.delete();
            } else if (files != null && files.length == 1 && ("package-info.java".equals(files[0].getName()) || files[0].getName().endsWith("-temp"))) {
                isDeleted = dir.delete();
            }
        }
        return isDeleted;
    }

    public static int getVersionValue(String ver) {
        String[] array = ver.split(Pattern.quote("."));
        StringBuilder builder = new StringBuilder();
        for (String str : array) {
            builder.append(str);
        }
        return Integer.parseInt(builder.toString());
    }
}

