/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava;

import java.io.IOException;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangTypeHolder;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaEnumerationFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaEventFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaRpcCommandFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaRpcFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;

public class TempJavaCodeFragmentFiles {
    private TempJavaBeanFragmentFiles beanTempFiles;
    private TempJavaTypeFragmentFiles typeTempFiles;
    private TempJavaServiceFragmentFiles serviceTempFiles;
    private TempJavaEnumerationFragmentFiles enumTempFiles;
    private TempJavaEventFragmentFiles eventTempFiles;
    private TempJavaRpcFragmentFiles rpcTempFiles;
    private TempJavaRpcCommandFragmentFiles rpcCommandTempFiles;

    public TempJavaCodeFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        int genType = javaFileInfo.getGeneratedFileTypes();
        if ((genType & 0x200F) != 0) {
            this.beanTempFiles = new TempJavaBeanFragmentFiles(javaFileInfo);
        }
        if ((genType & 0xC0) != 0) {
            this.typeTempFiles = new TempJavaTypeFragmentFiles(javaFileInfo);
        }
        if ((genType & 0x20) != 0) {
            this.enumTempFiles = new TempJavaEnumerationFragmentFiles(javaFileInfo);
        }
        if ((genType & 0x10) != 0) {
            this.serviceTempFiles = new TempJavaServiceFragmentFiles(javaFileInfo);
        }
        if ((genType & 0x700) != 0) {
            this.eventTempFiles = new TempJavaEventFragmentFiles(javaFileInfo);
        }
        if ((genType & 0x16000) != 0) {
            this.rpcTempFiles = new TempJavaRpcFragmentFiles(javaFileInfo);
        }
        if ((genType & 0x8000) != 0) {
            this.rpcCommandTempFiles = new TempJavaRpcCommandFragmentFiles(javaFileInfo);
        }
    }

    public TempJavaBeanFragmentFiles getBeanTempFiles() {
        return this.beanTempFiles;
    }

    public TempJavaTypeFragmentFiles getTypeTempFiles() {
        return this.typeTempFiles;
    }

    public TempJavaServiceFragmentFiles getServiceTempFiles() {
        return this.serviceTempFiles;
    }

    public TempJavaEnumerationFragmentFiles getEnumTempFiles() {
        return this.enumTempFiles;
    }

    public TempJavaEventFragmentFiles getEventFragmentFiles() {
        return this.eventTempFiles;
    }

    public TempJavaRpcFragmentFiles getRpcFragmentFiles() {
        return this.rpcTempFiles;
    }

    public TempJavaRpcCommandFragmentFiles getRpcCommandTempFiles() {
        return this.rpcCommandTempFiles;
    }

    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        if ((fileType & 0x200F) != 0) {
            this.beanTempFiles.generateJavaFile(fileType, curNode);
        }
        if ((fileType & 0xC0) != 0) {
            this.typeTempFiles.generateJavaFile(fileType, curNode);
        }
        if (fileType == 16) {
            this.serviceTempFiles.generateJavaFile(16, curNode);
        }
        if (fileType == 1792) {
            this.eventTempFiles.generateJavaFile(1792, curNode);
        }
        if (fileType == 32) {
            this.enumTempFiles.generateJavaFile(32, curNode);
        }
        if (fileType == 90112) {
            this.rpcTempFiles.generateJavaFile(90112, curNode);
        }
        if (fileType == 32768) {
            this.rpcCommandTempFiles.generateJavaFile(32768, curNode);
        }
    }

    void addTypeInfoToTempFiles(YangTypeHolder typeHolder, YangPluginConfig config) throws IOException {
        this.typeTempFiles.addTypeInfoToTempFiles(typeHolder, config);
    }

    public String addDefaultConstructor(String modifier, String toAppend) throws IOException {
        boolean isSuffix = false;
        if (this.typeTempFiles != null) {
            return this.typeTempFiles.addDefaultConstructor(modifier, toAppend, isSuffix);
        }
        if (this.beanTempFiles != null) {
            return this.beanTempFiles.addDefaultConstructor(modifier, toAppend, isSuffix);
        }
        throw new TranslatorException("default constructor should not be added");
    }

    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        if (this.beanTempFiles != null) {
            this.beanTempFiles.freeTemporaryResources(isErrorOccurred);
        }
        if (this.typeTempFiles != null) {
            this.typeTempFiles.freeTemporaryResources(isErrorOccurred);
        }
        if (this.enumTempFiles != null) {
            this.enumTempFiles.freeTemporaryResources(isErrorOccurred);
        }
        if (this.serviceTempFiles != null) {
            this.serviceTempFiles.freeTemporaryResources(isErrorOccurred);
        }
        if (this.eventTempFiles != null) {
            this.eventTempFiles.freeTemporaryResources(isErrorOccurred);
        }
        if (this.rpcTempFiles != null) {
            this.rpcTempFiles.freeTemporaryResources(isErrorOccurred);
        }
        if (this.rpcCommandTempFiles != null) {
            this.rpcCommandTempFiles.freeTemporaryResources(isErrorOccurred);
        }
    }
}

