/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.parserutils;

import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangConfig;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;

public final class ListenerValidation {
    private ListenerValidation() {
    }

    public static void checkStackIsNotEmpty(TreeWalkListener listener, ListenerErrorType errorType, YangConstructType yangConstructType, String parsableDataTypeName, ListenerErrorLocation errorLocation) {
        if (listener.getParsedDataStack().empty()) {
            String message = ListenerErrorMessageConstruction.constructListenerErrorMessage(errorType, yangConstructType, parsableDataTypeName, errorLocation);
            throw new ParserException(message);
        }
    }

    public static void checkStackIsEmpty(TreeWalkListener listener, ListenerErrorType errorType, YangConstructType yangConstructType, String parsableDataTypeName, ListenerErrorLocation errorLocation) {
        if (!listener.getParsedDataStack().empty()) {
            String message = ListenerErrorMessageConstruction.constructListenerErrorMessage(errorType, yangConstructType, parsableDataTypeName, errorLocation);
            throw new ParserException(message);
        }
    }

    public static boolean getParentNodeConfig(TreeWalkListener listener) {
        Parsable curData = listener.getParsedDataStack().peek();
        YangNode parentNode = ((YangNode)((Object)curData)).getParent();
        if (curData instanceof YangConfig) {
            return ((YangConfig)((Object)curData)).isConfig();
        }
        if (curData instanceof YangRpc || curData instanceof YangOutput || curData instanceof YangInput || curData instanceof YangNotification) {
            return false;
        }
        if (curData instanceof YangCase && parentNode instanceof YangChoice) {
            return ((YangChoice)parentNode).isConfig();
        }
        return true;
    }

    public static void validateCardinalityMaxOne(List<?> childContext, YangConstructType yangChildConstruct, YangConstructType yangParentConstruct, String parentName) throws ParserException {
        if (!childContext.isEmpty() && childContext.size() != 1) {
            ParserException parserException = new ParserException("YANG file error: \"" + YangConstructType.getYangConstructType(yangChildConstruct) + "\" is defined more than once in \"" + YangConstructType.getYangConstructType(yangParentConstruct) + " " + parentName + "\".");
            Iterator<?> context = childContext.iterator();
            parserException.setLine(((ParserRuleContext)context.next()).getStart().getLine());
            parserException.setCharPosition(((ParserRuleContext)context.next()).getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static void validateCardinalityEqualsOne(List<?> childContext, YangConstructType yangChildConstruct, YangConstructType yangParentConstruct, String parentName, ParserRuleContext parentContext) throws ParserException {
        if (childContext.isEmpty()) {
            ParserException parserException = new ParserException("YANG file error: Missing \"" + YangConstructType.getYangConstructType(yangChildConstruct) + "\" in \"" + YangConstructType.getYangConstructType(yangParentConstruct) + " " + parentName + "\".");
            parserException.setLine(parentContext.getStart().getLine());
            parserException.setCharPosition(parentContext.getStart().getCharPositionInLine());
            throw parserException;
        }
        if (!childContext.isEmpty() && childContext.size() != 1) {
            Iterator<?> childcontext = childContext.iterator();
            ParserException parserException = new ParserException("YANG file error: \"" + YangConstructType.getYangConstructType(yangChildConstruct) + "\" is present more than once in \"" + YangConstructType.getYangConstructType(yangParentConstruct) + " " + parentName + "\".");
            parserException.setLine(((ParserRuleContext)childcontext.next()).getStart().getLine());
            parserException.setCharPosition(((ParserRuleContext)childcontext.next()).getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static void validateCardinalityNonZero(List<?> childContext, YangConstructType yangChildConstruct, YangConstructType yangParentConstruct, String parentName, ParserRuleContext parentContext) throws ParserException {
        if (childContext.isEmpty()) {
            ParserException parserException = new ParserException("YANG file error: Missing \"" + YangConstructType.getYangConstructType(yangChildConstruct) + "\" in \"" + YangConstructType.getYangConstructType(yangParentConstruct) + " " + parentName + "\".");
            parserException.setLine(parentContext.getStart().getLine());
            parserException.setCharPosition(parentContext.getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static void validateCardinalityEitherOne(List<?> child1Context, YangConstructType yangChild1Construct, List<?> child2Context, YangConstructType yangChild2Construct, YangConstructType yangParentConstruct, String parentName, ParserRuleContext parentContext) throws ParserException {
        if (child1Context.isEmpty() && child2Context.isEmpty()) {
            ParserException parserException = new ParserException("YANG file error: Either \"" + YangConstructType.getYangConstructType(yangChild1Construct) + "\" or \"" + YangConstructType.getYangConstructType(yangChild2Construct) + "\" should be present in \"" + YangConstructType.getYangConstructType(yangParentConstruct) + " " + parentName + "\".");
            parserException.setLine(parentContext.getStart().getLine());
            parserException.setCharPosition(parentContext.getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static void validateCardinalityMutuallyExclusive(List<?> ctx1, YangConstructType type1, List<?> ctx2, YangConstructType type2, YangConstructType type, String parentName, ParserRuleContext ctx) throws ParserException {
        if (!ctx1.isEmpty() && !ctx2.isEmpty()) {
            String error = "YANG file error: Either " + YangConstructType.getYangConstructType(type1) + " or " + YangConstructType.getYangConstructType(type2) + " should be present in " + YangConstructType.getYangConstructType(type) + " " + parentName + ".";
            ParserException parserException = new ParserException(error);
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
    }
}

