/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangWhen;
import org.onosproject.yang.compiler.datamodel.YangWhenHolder;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class WhenListener {
    private WhenListener() {
    }

    public static void processWhenEntry(TreeWalkListener listener, GeneratedYangParser.WhenStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.WHEN_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        String condition = ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText());
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangWhenHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.WHEN_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangWhenHolder whenHolder = (YangWhenHolder)((Object)tmpNode);
        YangWhen when = new YangWhen();
        when.setCondition(condition);
        when.setLineNumber(ctx.getStart().getLine());
        when.setCharPosition(ctx.getStart().getCharPositionInLine());
        when.setFileName(listener.getFileName());
        whenHolder.setWhen(when);
        listener.getParsedDataStack().push(when);
    }

    public static void processWhenExit(TreeWalkListener listener, GeneratedYangParser.WhenStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.WHEN_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangWhen)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.WHEN_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

